#ifndef IRRADIANCE_H
#define IRRADIANCE_H

#include	"infrastructure/EKS.h"
#include	"transport/Orientation.h"
#include	"transport/Sun_position.h"
#include	"dimensions/Energy.h"
#include	"dimensions/Angle.h"

/*
** An intrinsic class used to encapsulate direct and
** diffuse irradiances with reference to the orientation
** of a plane and the position of the sun.
*/


class Irradiance {
private:
	/* Direct and diffuse radiation with reference to the orientation. */
	Energy		the_direct;
	Energy		the_diffuse;
	Orientation	the_orientation;
	Sun_position	the_sun_position;
public:
	/*given direct/diffuse referenced to surface with given orient. */
	Irradiance(Energy& a_direct, Energy& a_diffuse,
		   Orientation& a_orientation,
		   Sun_position& a_sun_position);
		
	Irradiance(Irradiance& i);
	~Irradiance();

	Irradiance& operator=(Irradiance& i);

	Energy direct();
	Energy diffuse();
	Orientation orientation();
	Sun_position sun_position();

	Angle solar_angle_of_incidence(Orientation& a_orientation,
		Sun_position& a_sun_position);
	Angle solar_angle_of_incidence();

friend	ostream&	operator<<(ostream& s, Irradiance& i);
};

inline Energy Irradiance::direct()
{
	return the_direct;
}

inline Energy Irradiance::diffuse()
{
	return the_diffuse;
}

inline Orientation Irradiance::orientation()
{
	return the_orientation;
}

inline Sun_position Irradiance::sun_position()
{
	return the_sun_position;
}

inline Angle Irradiance::solar_angle_of_incidence()
{
	return solar_angle_of_incidence(the_orientation,
		the_sun_position);
}
#endif
