#include	"transport/Irradiance.h"

#include	<math.h>


Irradiance::Irradiance( Energy& a_direct, Energy& a_diffuse,
			Orientation& a_orientation,
			Sun_position& a_sun_position)
				: the_orientation(a_orientation),
				  the_sun_position(a_sun_position)
{
	DEBUG << "Irradiance(float a_direct, float a_diffuse,";
	DEBUG << " Orientation& a_orientation,";
	DEBUG << " Sun_position& a_sun_position)\n";
	the_direct=a_direct;
	the_diffuse=a_diffuse;
}

Irradiance::Irradiance(Irradiance& i)
: the_orientation(i.the_orientation), the_sun_position(i.the_sun_position)
{
	DEBUG << "Irradiance::Irradiance(Irradiance& i)\n";
	the_direct=i.the_direct;
	the_diffuse=i.the_diffuse;
}

Irradiance::~Irradiance()
{
	DEBUG << "Irradiance::~Irradiance()\n";
}

Irradiance& Irradiance::operator=(Irradiance& i)
{
	DEBUG << "Irradiance& Irradiance::operator=(Irradiance& i)\n";
	if(this==&i) return *this;
	the_direct=i.the_direct;
	the_diffuse=i.the_diffuse;
	the_orientation=i.the_orientation;
	the_sun_position=i.the_sun_position;
	return *this;
}

/*
** Calculate the solar angle of incidence.
** PAZI is the plane azimuth angle - the angle measured from
** north (Y-axis) in degrees - clockwise positive.
** PELV is the plane elevation angle - angle between the surface
** outward normal and the horizontal measured vertically in
** degrees.
** Returns the angle of incidence between the sun and surface.
*/
Angle Irradiance::solar_angle_of_incidence(Orientation& a_orientation,
	Sun_position& a_sun_pos_ptr)
{
	DEBUG1 << "Irradiance::solar_angle_of_incidence";
	DEBUG1 << "(Orientation&, Sun_position&)\n";

	float PAZI=a_orientation.azimuth();
	float PELV=a_orientation.elevation();
	float ANGI;		// Angle of incidence between sun and surface
	float R=3.14159/180.;
	float PSAZI; 		// Surface-solar azimuth angle for surface
	float CAI; 		// Cosine of angle incidence.

	R=3.14159/180.;

	float SALT=a_sun_pos_ptr.elevation();
	float SAZI=a_sun_pos_ptr.azimuth();

/*  Surface-solar azimuth angle for this external construction. */
	PSAZI=fabs(PAZI-SAZI);

/*  Angle of incidence and its cosine. */
	CAI=cos(SALT*R)*sin((90.-PELV)*R)*cos(PSAZI*R)
		+sin(SALT*R)*cos((90.-PELV)*R);
	if(CAI < 0.) CAI=0.;
	ANGI=acos(CAI)/R;

/* Outputs. */
      return Angle(ANGI);
}


ostream&	operator<<(ostream& s, Irradiance& i)
{
	DEBUG1	<< "operator<<(ostream& s, Irradiance& i)\n";

	s << i.the_direct << "+"  << i.the_diffuse
	  << "@" << i.the_orientation << "->" << i.the_sun_position;

	return s;
};
