#ifndef FINISH_H
#define FINISH_H

#include	"infrastructure/EKS.h"
#include	"dimensions/Proportion.h"
class	APL;

/* 
** properties of surface finish.  Separate from material 
** because behaviour will vary with treatment 
*/


class Finish {
protected:
        Proportion	the_emissivity;	 // assumed =absorptivity (grey body)
        Proportion	the_reflectivity;// reflectivity over whole spectrum
        float		the_roughness;	 // roughness index
//	Colour		the_colour;	 // colour of surface NOT DEFINED YET
public:
        Finish(Proportion emis, Proportion refl, float rough);
        Finish(Finish& fin);
	Finish(APL* theAPL);

        Finish& operator=(Finish& fin);

	Proportion	transmissivty();
	Proportion	emissivity();
	Proportion	reflectivity();
	float		roughness();
};

#endif
