#include	"transport/Finish.h"


Finish::Finish(Proportion emis, Proportion refl, float rough)
				: the_emissivity(emis),
				  the_reflectivity(refl),
				  the_roughness(rough)
{
	DEBUG << "Proportion emis, Proportion refl, float rough);\n";
};

Finish::Finish(Finish& fin)	: the_emissivity(fin.the_emissivity),
				  the_reflectivity(fin.the_reflectivity),
				  the_roughness(fin.the_roughness)
{
	DEBUG << "Finish(Finish& fin)\n";
};


Finish::Finish(APL* theAPL)
{
	DEBUG << "Finish(APL* theAPL)\n";
};


Finish& Finish::operator=(Finish& fin)    
{
	DEBUG1 << "Finish::operator=(Finish& fin)\n";

        if (this==&fin) return (*this);

	the_emissivity=fin.the_emissivity;
	the_reflectivity=fin.the_reflectivity;
	the_roughness=fin.the_roughness;

        return (*this);
};

Proportion	Finish::transmissivty()
{
	DEBUG1 << "Proportion	Finish::transmissivty()\n";

	return Proportion(Proportion(1.) - the_emissivity - the_reflectivity);
};

Proportion	Finish::emissivity()
{
	DEBUG1 << "Proportion	Finish::emissivity()\n";

	return the_emissivity;
};

Proportion	Finish::reflectivity()
{
	DEBUG1 << "Proportion	Finish::reflectivity()\n";

	return the_reflectivity;
};

float		Finish::roughness()
{
	DEBUG1 << "Proportion	Finish::roughness()\n";

	return the_roughness;
};

