#include	"transport/FilledVolume.h"

#include	"dimensions/Mass.h"


FilledVolume::FilledVolume(Volume& vol, Substance& sub)
				: theVolume(vol), theSubstance(sub)
{
	DEBUG << "FilledVolume::FilledVolume()\n";
};

FilledVolume::FilledVolume(FilledVolume& filvol)
				: theVolume(filvol.theVolume),
				  theSubstance(filvol.theSubstance)
{
	DEBUG << "FilledVolume::FilledVolume(FilledVolume& filvol)\n";
};

FilledVolume::~FilledVolume()
{
	DEBUG << "FilledVolume::~FilledVolume()\n";
};


FilledVolume& FilledVolume::operator=(FilledVolume& filvol)
{
	DEBUG << "FilledVolume::operator=(FilledVolume& filvol)\n";
   
	if (this==&filvol) return (*this);

	theVolume=filvol.volume();
	theSubstance=filvol.substance();

        return (*this);
};

Volume	FilledVolume::volume()
{
	DEBUG << "Volume	FilledVolume::volume()\n";
   
	return theVolume;
};

Substance	FilledVolume::substance()
{
	DEBUG << "Substance	FilledVolume::substance()\n";
   
	return theSubstance;
};

Mass	FilledVolume::mass()
{
	DEBUG << "Mass	FilledVolume::mass()\n";
   
	return Mass(theVolume * theSubstance.density());
};
