#ifndef EQUATION_SET_H
#define EQUATION_SET_H

#include	"infrastructure/EKS.h"
#include	"infrastructure/list.h"
#include	"transport/Equation.h"
template_define(List,Equation);
class	APL;

enum	EquationOrder { REVERSE_EQNS=-1, INVALIDSET, AS_EQNS };

/* This class encapsulates equations for a physical object.*/


class Equation_set  : private List(Equation) {
friend	Equation_iterator;
protected:
	List_iterator(Equation)	eqn_iter;
public:
	Equation_set();
	Equation_set(Equation_set& e);				// shallow copy
	Equation_set(APL* theAPL);
	~Equation_set();

	Equation_set& operator=(Equation_set& e);   // shallow copy
	Equation_set& operator+=(Equation_set& e);  // shallow copy
	Equation_set& operator=(Equation_iterator e_itr);   // shallow copy
	Equation_set& operator+=(Equation_iterator e_itr);  // shallow copy

	int			size();
	Equation*		first();
	Equation*		last();
	void			append(Equation* eqn);
	void			insert(Equation* eqn);

	Equation*		operator[](int i);
	Equation_iterator	iterator(EquationOrder order = AS_EQNS);

friend	ostream&	operator<<(ostream& s, Equation_set& es);
};


			/************************************************/


/* This class implements an iterator over an Equation_set.*/


class Equation_iterator  : private List_iterator(Equation) {
	Boolean		list_direction;
public:
	Equation_iterator(Equation_set* e, EquationOrder order = AS_EQNS);
	~Equation_iterator();
	Equation_iterator(Equation_iterator& e_itr);		// shallow copy

	Equation_iterator& operator=(Equation_iterator& e_itr);	// shallow copy

	int		size();
	Equation*	operator[](int i);
	Equation*	operator()(int d);
	Equation*	last();
};

#endif
