#include	"transport/Equation_set.h"


Equation_set::Equation_set()  : (), eqn_iter(this)
{
	DEBUG << "Equation_set::Equation_set(Layer_es*, int a_layer_no)\n;"
}

Equation_set::Equation_set(Equation_set& e)  : ((List(Equation)) e), eqn_iter(this)
{
	DEBUG << "Equation_set::Equation_set(Equation_set& e)\n;"
}

Equation_set::Equation_set(APL* theAPL)
{
	DEBUG << "Equation_set(APL* theAPL)\n";
};

Equation_set::~Equation_set()
{
	DEBUG << "Equation_set::~Equation_set()\n;"
}

Equation_set& Equation_set::operator=(Equation_set& e)
{
	DEBUG1 << "Equation_set::operator=(Equation_set& e)\n;"

	(void)	List(Equation)::operator=(e);

	return *this;
};

Equation_set& Equation_set::operator+=(Equation_set& e)
{
	DEBUG1 << "Equation_set::operator=(Equation_set& e)\n;"

	(void)	List(Equation)::operator+=(e);

	return *this;
};

Equation_set& Equation_set::operator=(Equation_iterator e_itr)
{
	DEBUG1 << "Equation_set::operator=(Equation_iterator e_itr)\n;"

	(void)	List(Equation)::clear();
	(void) e_itr(RESET);
	Equation*	eqn;
	while (eqn = e_itr(FORWARD))
		append(eqn);

	return *this;
};

Equation_set& Equation_set::operator+=(Equation_iterator e_itr)
{
	DEBUG1 << "Equation_set::operator=(Equation_iterator e_itr)\n;"

	(void) e_itr(RESET);
	Equation*	eqn;
	while (eqn = e_itr(FORWARD))
		append(eqn);

	return *this;
};


int	Equation_set::size()
{
	return List(Equation)::size();
};

Equation*	Equation_set::first()
{
	return List(Equation)::first();
};

Equation*	Equation_set::last()
{
	return List(Equation)::last();
};

void	Equation_set::insert(Equation* eqn)
{
	List(Equation)::insert(eqn);
};

void	Equation_set::append(Equation* eqn)
{
	List(Equation)::append(eqn);
};

Equation*	Equation_set::operator[](int i)
{
	return eqn_iter[i];
};

Equation_iterator	Equation_set::iterator(EquationOrder order)
{
	Equation_iterator iter(this, order);

	return iter;
};


ostream&	operator<<(ostream& s, Equation_set& es)
{
	s << " eqn set\n";
	es.eqn_iter(RESET);
	Equation* e;
	while (e = es.eqn_iter(FORWARD))
		s << "    " << *e;
	s << "\n\n";

	return s;
};


			/************************************************/


Equation_iterator::Equation_iterator(Equation_set* e, EquationOrder order)
							: ((List(Equation)*)e)
{
	DEBUG << "Equation_iterator::Equation_iterator(Equation_set& e, EquationOrder order)\n;"

	list_direction = order;
};

Equation_iterator::~Equation_iterator()
{
	DEBUG << "Equation_iterator::~Equation_iterator()\n;"
};

Equation_iterator::Equation_iterator(Equation_iterator& e_itr)
					: ((List_iterator(Equation)&) e_itr)
{
	DEBUG << "Equation_iterator::Equation_iterator(Equation_iterator& e_itr)\n;"

	list_direction = e_itr.list_direction;
};

Equation_iterator& Equation_iterator::operator=(Equation_iterator& e_itr)
{
	DEBUG1 << "Equation_iterator::operator=(Equation_iterator& e_itr)\n;"

	(void)	List_iterator(Equation)::operator=(e_itr);
	list_direction = e_itr.list_direction;

	return *this;
};

int	Equation_iterator::size()
{
	DEBUG1 << "Equation_iterator::size()\n;"

	return List_iterator(Equation)::size();
};

Equation*	Equation_iterator::operator[](int i)
{
	DEBUG1 << "Equation_iterator::operator[](int i)\n;"

	if (list_direction == REVERSE_EQNS)
		i = size()-1 - i;			// index from end of list
	return List_iterator(Equation)::operator[](i);
};

Equation*	Equation_iterator::operator()(int d)
{
	DEBUG1 << "Equation_iterator::operator()(int d)\n;"

	if (list_direction == REVERSE_EQNS)
		d = 0 - d;		// invert FORWARD & BACKWARD

	return List_iterator(Equation)::operator()(d);
};

Equation*	Equation_iterator::last()
{
	DEBUG1 << "Equation_iterator::last()\n;"

	if (list_direction == REVERSE_EQNS)
		return list->first();
	else
		return list->last();
};




template_implement(List,Equation);
