#ifndef EQUATION_H
#define EQUATION_H

#include	"infrastructure/EKS.h"
#include	"infrastructure/list.h"
#include	"transport/Coefficient.h"
#include	"dimensions/ThermalResistance.h"
#include	"dimensions/SpecificHeatCapacity.h"
#include	"dimensions/Energy.h"
template_define(List,Coefficient);

enum Equation_enum { ENERGY };

/* 
** This class represents a state equation - ie of the
** form x'=Ax+B where x' is the time derivative (perhaps
** identically zero), x is any state variable and A and B
** are arbitrarily complex coefficients.
*/


class Equation {
protected:
	Equation_enum		the_equation_enum; 	/* The equation type */
	State_variable*		the_state_variable;	/* id of the eqn's SV */
	List(Coefficient)	the_coefficients;	/* List of coeffs in eqn*/
	Energy 			the_gain;

	ThermalResistance 	the_resistance;
	SpecificHeatCapacity 	the_capacity;
public:
	Equation(State_variable* a_state_variable, Equation_enum a_equation_enum,
		 float self_coupling_coeff, Energy initial_gain,
		 ThermalResistance resist, SpecificHeatCapacity capac);
	Equation(Equation& e);			// deep copy
	~Equation();

	Equation& operator=(Equation& e);	// deep copies values only, not SV

	State_variable*	state_variable();
	Equation_enum	equation_enum();
	Energy 		gain();
	ThermalResistance	resistance();
	SpecificHeatCapacity	capacity();

	void 		append_coefficient(State_variable* a_state_variable,
					   float a_value,
/**/					   State_variable_enum a_state);
	void 		change_coefficient(State_variable* a_state_variable,
					   float a_value);
	void 		remove_coefficient(State_variable* a_state_variable);
	float 		coefficient_value(State_variable* a_state_variable);
	void		add_gain(Energy a_value);

friend	ostream&	operator<<(ostream& s, Equation& e);

	List_iterator(Coefficient)	coeff_iterator();
};
#endif
