#ifndef COEFFICIENT_H
#define COEFFICIENT_H

#include	"infrastructure/EKS.h"
#include	"transport/State_variable.h"
class	Equation;

enum State_variable_enum { ENTHALPY, TEMPERATURE, MASS_FLOW_RATE };

/* 
** This class represents a single Coefficient within
** a state equation.  It is normally only used in association
** with Equation objects.  Coefficients are specified in terms
** of a value and a state variable identifier.
*/


class Coefficient {
protected:
					// avoids Equation having to recreate
					// Coefficient when updating itself
friend	Equation;
////friend	void	Equation::append_coefficient(State_variable* a_state_variable,
////					     float a_value,
////					     State_variable_enum a_state);
        float			the_value;		 /* Value of coefficient */
        State_variable*		the_state_variable;	 /* Node identifier. */
	State_variable_enum	the_state_variable_enum; /* state var type. */
public:
	Coefficient(State_variable* a_state_variable, float a_value,
		    State_variable_enum a_state);
	Coefficient(Coefficient& c);
	~Coefficient();

	Coefficient& operator=(Coefficient& c); // deep copies values only 

	float			value();
	State_variable*		state_variable();
	State_variable_enum	state_variable_enum();

friend	ostream&	operator<<(ostream& s, Coefficient& c);
};
#endif
