#include	"transport/Coefficient.h"


Coefficient::Coefficient(State_variable* a_state_variable, float a_value,
			 State_variable_enum a_state)

{
	DEBUG << "Coefficient::Coefficient(State_variable*, float,\n";
	DEBUG << "  State_variable_enum )\n";

	the_state_variable = a_state_variable;
	the_value = a_value;
	the_state_variable_enum = a_state;
};

Coefficient::Coefficient(Coefficient& c)
{
	DEBUG << "Coefficient::Coefficient(Coefficient& c)\n";

	the_state_variable = c.the_state_variable;
	the_value= c.the_value;
	the_state_variable_enum= c.the_state_variable_enum;
};

Coefficient::~Coefficient()
{
	DEBUG << "Coefficient::~Coefficient()\n";
};


Coefficient& Coefficient::operator=(Coefficient& c)
{
	DEBUG1 << "Coefficient::operator=(Coefficient& c)\n";

	if(this==&c) return *this;

	if (the_state_variable_enum != c.the_state_variable_enum)
		cerr << "Coefficient::op=():  assigned coeff of different type!\n"
		     << "                    value not changed\n";
	else {
		if (the_state_variable != c.the_state_variable)
			cerr << "Coefficient::op=():  Warning!  assigned coeff "
			     << "is for a different state_variable\n";
		the_value = c.the_value;
	};

	return *this;
};


float Coefficient::value()
{
	DEBUG1 << "float Coefficient::value(\n";

	return the_value;
};

/* 
** Return the node identifier.
*/
State_variable* Coefficient::state_variable()
{
	DEBUG1 << "State_variable* Coefficient::state_variable()\n";

	return the_state_variable;
};

/*
** Return the state variable type i.e. enthalpy, temperature, etc.
*/
State_variable_enum Coefficient::state_variable_enum()
{
	DEBUG1 << "State_variable_enum Coefficient::state_variable_enum()\n";

	return the_state_variable_enum;
};


ostream&	operator<<(ostream& s, Coefficient& c)
{
	State_variable_enum	cotype = c.the_state_variable_enum;

	s << (cotype==ENTHALPY ? "Enthalpy" :
	      cotype==TEMPERATURE ? "Temp" :
	      cotype==MASS_FLOW_RATE ? "Mass flow rate" :
					  "unknown type")
	  << " coeff (sv_id " << c.the_state_variable->id()
	  << ") " << c.the_value
	  << "\n";

	return s;
};
