#ifndef ClimateSetH
#define ClimateSetH

#include	"infrastructure/EKS.h"
#include	"transport/Time_of_day.h"
#include	"transport/Location.h"
class	Profile;
class	ClimateRecord;
#include	"infrastructure/list.h"
template_define(List,Profile);

/* A climate set contains a list of climate profiles
 * a location, start and end times, and current time.
 * Note aOffset range different from range()/interval
 *  e.g. range=100-50=25 in intervals of 2, but offset
 * goes from 0...24
 */


class ClimateSet {
protected:
	filebuf	fp;
	istream		climateFile;

	List(Profile)	theClimate;
        List_iterator(Profile)	profileIter;
	Location	theLocation;
	Time_of_day	theStart;
	Time_of_day	theFinish;
	Time_of_day	theInterval;
	int		no_profiles;
	int		no_records;


	filebuf*		getstream(char* filename);
	Location&	getloc();
	Time_of_day&	gettod();
public:
	ClimateSet(char* filename);
        ClimateSet(Location& loc, Time_of_day start, Time_of_day finish,
						Time_of_day interval);
        ClimateSet(ClimateSet& clmSet);
	~ClimateSet();

	ClimateSet&	operator=(ClimateSet& clmSet);

	void		addProfile(Profile* array);

	ClimateRecord	climateRecord(Time_of_day& time);
	Location		location()	{ return theLocation; }
	Time_of_day		interval()	{ return theInterval; }
	Time_of_day		start()		{ return theStart; }
	Time_of_day		finish()	{ return theFinish; }
	Time_of_day		range()		{ return theFinish-theStart;}
	int		numberRecords()		{ return no_records; }
	int		numberProfiles()	{ return no_profiles; }
};

#endif
