#include	"transport/ClimateSet.h"

#include	<string.h>
#include	<stdlib.h>
#include	"transport/Profile.h"
#include	"transport/ClimateRecord.h"


filebuf*	ClimateSet::getstream(char* filename)
{
	fp.open(filename, input);
	return &fp;
};

Location&	ClimateSet::getloc()
{
	char	loc[80];
	climateFile.getline(loc, 80);
	float	lat, lng, elv;
	climateFile >> lat >> lng >> elv;

	return Location(loc, lat, lng, elv);
};

Time_of_day&	ClimateSet::gettod()
{
	int  yr, ydy, hr, mn;
	climateFile >> yr >> ydy >> hr >> mn;

	return Time_of_day(0.0, mn, hr, ydy, yr);
};


ClimateSet::ClimateSet(char* filename)  : climateFile(getstream(filename)),
				  theClimate(), profileIter(&theClimate),
				  theLocation(getloc()), theStart(gettod()),
				  theFinish(gettod()), theInterval(gettod())
{
	climateFile >> no_profiles ;

	Profile**	profile_array = (Profile**)malloc(no_profiles * sizeof(Profile*));
	char	profile_name[32];
	for (int i = 0; i < no_profiles; i++) {
		climateFile >> profile_name;
		profile_array[i] = new Profile(profile_name);
		addProfile(profile_array[i]);
	};

	no_records = 0;
	int	climateData;
	while (!(climateFile.eof())) {
		for (int i = 0; i < no_profiles; i++) {
			climateFile >> climateData;
			profile_array[i]->append(climateData);
		};
		no_records++;
	};
};

ClimateSet::ClimateSet(Location& loc, Time_of_day start, Time_of_day finish,
		       Time_of_day interval) : climateFile(NULLPTR(filebuf)),
				  theClimate(), profileIter(&theClimate),
				  theLocation(loc), theStart(start),
				  theFinish(finish), theInterval(interval)
{
	DEBUG << "ClimateSet(Location loc, Time_of_day start, Time_of_day finish, Time_of_day interval)\n";
	if (start >= finish) {
		cout << "range in ClimateSet, start >= finish\n";
		exit(-1);
	};
};

ClimateSet::ClimateSet(ClimateSet& clmSet) : climateFile(NULLPTR(filebuf)),
				  theClimate(), profileIter(&theClimate),
				  theLocation(clmSet.theLocation),
				  theStart(clmSet.theStart),
				  theFinish(clmSet.theFinish),
				  theInterval(clmSet.theInterval)
{
        DEBUG << "ClimateSet(ClimateSet& clmSet)\n";

	List_iterator(Profile) iter(&(clmSet.theClimate));
	Profile* aProfile;
	while (aProfile = iter(FORWARD))
		addProfile(aProfile);
};

ClimateSet::~ClimateSet()
{
	DEBUG << "ClimateSet::~ClimateSet()\n";
	profileIter(RESET);
	Profile* aProfile;
	while (aProfile = profileIter(FORWARD))
		delete(aProfile);
};

ClimateSet& ClimateSet::operator=(ClimateSet& clmSet)
{
        DEBUG << "ClimateSet::operator=\n";
        if (this==&clmSet) return (*this);
	theLocation = clmSet.theLocation;
	theStart=clmSet.start();
	theFinish=clmSet.finish();
	theInterval=clmSet.interval();

	List_iterator(Profile) iter(&(clmSet.theClimate));
	Profile* aProfile;
	while (aProfile = iter(FORWARD))
		addProfile(aProfile);

	return (*this);
}

void ClimateSet::addProfile(Profile* aProfile)
{
	if (aProfile->size() < numberRecords()) {
		cout << "setProfile error in ClimateSet, profile too small\n";
		exit(-1);
	} else {
       		theClimate.append(aProfile);
	};
};

ClimateRecord	ClimateSet::climateRecord(Time_of_day& time)
{
	DEBUG1	<< "ClimateSet::clmset(" << time << ")\n";

	int recordNo = (int)((time-theStart)/theInterval);

	Temperature	dbtemp = -999, wbtemp = -999;
	Energy		drrad = -999, dfrad = -999;
	Speed		windspd = -999;
	Angle		winddir = -999;
	profileIter(RESET);
	Profile* aProfile;
	while (aProfile = profileIter(FORWARD))
		if (!strncmp(aProfile->name(),"TemperatureDryBulb", 18))
			dbtemp = (float)(*aProfile)[recordNo];
		else if (!strncmp(aProfile->name(),"TemperatureWetBulb", 18))
			wbtemp = (float)(*aProfile)[recordNo];
		else if (!strncmp(aProfile->name(),"RadiationDirect", 15))
			drrad = (float)(*aProfile)[recordNo];
		else if (!strncmp(aProfile->name(),"RadiationDiffuse", 16))
			dfrad = (float)(*aProfile)[recordNo];
		else if (!strncmp(aProfile->name(),"WindSpeed", 9))
			windspd = (float)(*aProfile)[recordNo];
		else if (!strncmp(aProfile->name(),"WindDirection", 13))
			winddir = (float)(*aProfile)[recordNo];
	ClimateRecord aRecord(dbtemp, wbtemp, drrad, dfrad, windspd,winddir);
	return aRecord;
};



template_implement(List,Profile);
