#ifndef CLIMATEREGIME_H
#define CLIMATEREGIME_H

#include	"infrastructure/EKS.h"
#include	"infrastructure/list.h"
#include	"transport/Irradiance.h"
#include	"dimensions/Temperature.h"
#include	"dimensions/Speed.h"
#include	"dimensions/Angle.h"
#include	"dimensions/Proportion.h"
#include	"transport/Irradiance.h"
template_define(List,Irradiance);

/* Solar radiation is hels as as list of 5 resolved irradiances, respecively
 *		south facing vertiacl surface
 *		north facing vertiacl surface
 *		west facing vertiacl surface
 *		east facing vertiacl surface
 *		up[ward facing horrizontal surface
 */

class ClimateRegime{
private:
	Temperature	the_temperature_dry;	// Dry bulb temperature.
	Speed		the_wind_speed;		// Wind speed and direction
	Angle		the_wind_direction;	//     10m after obstruction.
	Proportion	the_relative_humidity;	// Relative humidity.
	List(Irradiance) irradiances;		// list of irradiances.
public:	
	ClimateRegime(Temperature a_temperature_dry,
		       Speed a_wind_speed, Angle a_wind_direction,
		       Proportion a_relative_humidity,
		       List(Irradiance)* a_irradiance_list);	// deep copy
	ClimateRegime(ClimateRegime& c);			// deep copy
	~ClimateRegime();

	ClimateRegime& operator=(ClimateRegime& c);	// deep copy

	Temperature	temperature_dry()    { return the_temperature_dry;}
	Speed		wind_speed()	     { return the_wind_speed;}
	Angle		wind_direction()     { return the_wind_direction;}
	Proportion	relative_humidity()  { return the_relative_humidity;}

	List_iterator(Irradiance)  get_iterator();

friend	ostream&	operator<<(ostream& s, ClimateRegime& r);
};

#endif
