#include	"transport/ClimateRegime.h"

#include	"transport/Irradiance.h"


ClimateRegime::ClimateRegime (Temperature a_temperature_dry,
				Speed a_wind_speed, Angle a_wind_direction,
				Proportion a_relative_humidity,
				List(Irradiance)* a_irradiance_list)
			: the_temperature_dry(a_temperature_dry),
			  the_wind_speed(a_wind_speed),
			  the_wind_direction(a_wind_direction),
			  the_relative_humidity(a_relative_humidity),
			  irradiances()
{
	DEBUG << "ClimateRegime::ClimateRegime(";
	DEBUG << "  Temperature, Speed, Angle, Proportion, Irradiance_list&)\n";

				/* deep copy irradiances, if any */
	if (a_irradiance_list) {
		List_iterator(Irradiance) iter(a_irradiance_list);
		Irradiance*	ptr;
		while (ptr = iter(FORWARD)) {
			Irradiance* irrad_copy = new Irradiance(*ptr);
			irradiances.append(irrad_copy);
		};
	};
};
			
ClimateRegime::ClimateRegime(ClimateRegime& c)
			: the_temperature_dry(c.the_temperature_dry),
			  the_wind_speed(c.the_wind_speed),
			  the_wind_direction(c.the_wind_direction),
			  the_relative_humidity(c.the_relative_humidity),
			  irradiances()
{;
	DEBUG << "ClimateRegime::ClimateRegime(ClimateRegime&)\n";

				/* deep copy irradiances, if any */
	if (c.irradiances.size() != 0) {
		List_iterator(Irradiance) iter(&(c.irradiances));
		Irradiance*	ptr;
		while (ptr = iter(FORWARD)) {
			Irradiance* irrad_copy = new Irradiance(*ptr);
			irradiances.append(irrad_copy);
		};
	};
};

ClimateRegime::~ClimateRegime()
{
	DEBUG << "ClimateRegime::~ClimateRegime()\n";

	/* Delete all the Irradiance objects in the irradiance list. */
	if (irradiances.size() != 0) {
		List_iterator(Irradiance) iter(&irradiances);
		Irradiance* ptr;
		while(ptr=iter(FORWARD))
			delete ptr;
		irradiances.clear();
	};
};

ClimateRegime& ClimateRegime::operator=(ClimateRegime& c)
{
	DEBUG << "ClimateRegime::operator=(ClimateRegime&)\n";

	if (this==&c) return *this;

	the_temperature_dry = c.the_temperature_dry;
	the_wind_speed = c.the_wind_speed;
	the_wind_direction = c.the_wind_direction;
	the_relative_humidity = c.the_relative_humidity;

	/* Delete all the Irradiance objects in the irradiance list. */
	if (irradiances.size() != 0) {
		List_iterator(Irradiance) iter_this(&irradiances);
		Irradiance* ptr;
		while(ptr=iter_this(FORWARD))
			delete ptr;
		irradiances.clear();
	};

	if (c.irradiances.size() != 0) {
		List_iterator(Irradiance) iter_that(&(c.irradiances));
		Irradiance* ptr;
		Irradiance* irrad_copy;
		while(ptr=iter_that(FORWARD)) {
			irrad_copy = new Irradiance(*ptr);
			irradiances.append(irrad_copy);
		};
	};

	return *this;
};

List_iterator(Irradiance) ClimateRegime::get_iterator()
{
	DEBUG1 << "ClimateRegime::get_iterator();\n";

	List_iterator(Irradiance) iter(&irradiances);
	return iter;
};


ostream&	operator<<(ostream& s, ClimateRegime& r)
{
	DEBUG1	<< "operator<<(ostream& s, ClimateRegime& r)\n";

	s << r.the_temperature_dry << "deg" 
	  << r.the_wind_speed << "m/s" << r.the_wind_direction << "Z"
	  << r.the_relative_humidity << "rh";
	if (r.irradiances.size() != 0) {
		List_iterator(Irradiance) iter(&r.irradiances);
		Irradiance* ptr;
		while(ptr=iter(FORWARD))
			s << ptr << "  ";
	};

	return s;
};


template_implement(List,Irradiance);
