#ifndef	CLIMATERECORD_H
#define	CLIMATERECORD_H

#include	"infrastructure/EKS.h"
#include	"dimensions/Temperature.h"
#include	"dimensions/Angle.h"
#include	"dimensions/Speed.h"
#include	"dimensions/Energy.h"


class ClimateRecord {
protected:
        Temperature	theDryBulb;
        Temperature	theWetBulb;
	Energy		theDirectNS;
	Energy		theDiffuseHS;
	Speed		theWindSpeed;
	Angle		theWindDir;
 
public:
	ClimateRecord( 
		   Temperature aDryBulb, 
		   Temperature aWetBulb, 
		   Energy aDirectNS, 
		   Energy aDiffuseHS,
		   Speed aWindSpeed, 
		   Angle aWindDir
		      );
	ClimateRecord(float aDryBulb,
                   float aWetBulb,
                   float aDirectNS,
                   float aDiffuseHS,
                   float aWindSpeed,
                   float aWindDir
			);

	Temperature	dryBulb()		{ return theDryBulb; };
	Temperature	wetBulb()		{ return theWetBulb; };
	Energy		directNormalSolar()	{ return theDirectNS; }
	Energy		diffuseHorizontalSolar(){ return theDiffuseHS; }
	Angle		windDirection()		{ return theWindDir; }
	Speed		windSpeed()		{ return theWindSpeed; }
};
#endif
