#include	<stdlib.h>
#include	<stream.h>
#include	"infrastructure/Metaproto.h"



static	char	protopath[128]	= {"^EKSprototypeMetaclasses>"};

// create a dummy Template class to gain access to Metaprotos private data
class Template {
public:
	Template()	{}
static	Metaproto*	makeMetaproto(char* class_name)
				{ return new Metaproto(class_name); };
static	Type*		get_x_def_type(Metaproto* mp)
				{ return mp->x_def_type; };
static	Metaproto*	get_proto(char* class_name);
static	void		zap_proto(Metaproto* mp, Boolean deallocate)
				{ mp->deleteObject(deallocate); };
static	void		describe_metaproto(ostream& strm, char* class_name);
};

Metaproto*	Template::get_proto(char* class_name)
{
	strcpy(&protopath[25], class_name);
	Metaproto*   mp = (Metaproto*)OC_lookup(protopath);
	return mp;
};

void	Template::describe_metaproto(ostream& strm, char* class_name)
{
	Metaproto*   mp = get_proto(class_name);

	strm << "    Metaclass Prototype for " << mp->protege_class_name << "\n"
	     << "    base class: " << mp->protege_base_name << "\n"
	     << "    x_def class: " << mp->x_def_class_name << "\n";

	if (mp->callers->size()) {
	     	strm << "    acceptable callers: \n";
		List_iterator(char)	c_iter(mp->callers);
		char*	clr;
		while (clr = c_iter(FORWARD))
	     		strm << "        " << clr << "\n";
	};
	if (mp->auxiliaries->size()) {
	     	strm << "    auxiliaries used: \n";
		List_iterator(char)	c_iter(mp->auxiliaries);
		char*	clr;
		while (clr = c_iter(FORWARD))
	     		strm << "        " << clr << "\n";
	};
};



main()
{
	OC_open(getenv("DBNAME"));
	OC_transactionStart();

	Directory* pd = (Directory*)OC_lookup("^EKSprototypeMetaclasses");
	if (pd == NULLPTR(Directory)) {
		cout << "Creating the prototype directory\n";
		pd = new Directory("^EKSprototypeMetaclasses");
		pd->putObject(FALSE);
	};

	char	class_name[128];
	cout << "name of new class? ";
	cin >> class_name;

					// Check class is known
/***	Type*	class_type = (Type*)OC_lookup(class_name);
	if ( class_type == NULLPTR(Type)  ||
	     class_type->AKO(TYPE_OF(EKSObject)) == FALSE ) {
		char	class_filename[128];
		cout << "filename of .h file? ";
		cin >> class_filename;
		if (strlen(class_filename)) {
			char	cmd[128];
			sprintf(cmd,"classify +RS +F %s\n", class_filename);
			system(cmd);
			class_type = (Type*)OC_lookup(class_name);
		};
	};
					// check if Metaproto already exists
	Metaproto*	m = Template::get_proto(class_name);
	if (m != NULLPTR(Metaproto)) {
		cout << "A Metaproto for " << class_name << "already exits:\n";
		Template::describe_metaproto(cout, m);
		cout << "\n\nDo you want to overwrite it? ";
		if (!YES)
			exit(1);
		Template::zap_proto(m);
	};
***/

	Metaproto*	mp = Template::makeMetaproto(class_name);

	Type*	x_def_type = Template::get_x_def_type(mp);
	if ( x_def_type == NULLPTR(Type)  ||
	     x_def_type->AKO(TYPE_OF(EKSObject)) == FALSE ) {
		char	x_def_filename[128];
		cout << "filename of X-def's .h file? ";
		cin >> x_def_filename;
		char	cmd[128];
		sprintf(cmd, "classify +F %s  &\n", x_def_filename);
		system(cmd);
	};

				// check definition ok
	
	cout << "\nMetaproto definition:\n";
	Template::describe_metaproto(cout, class_name);

	char	ans[4];
	cout << "Commit? ";
	cin >> ans;
	if (*ans == 'y')  OC_transactionCommit();
	else   OC_transactionAbort();
	OC_close();
};
	
