#include	<stream.h>
#include	"infrastructure/Metaproto.h"



// create a dummy Template class to gain access to Metaprotos private data
static	char	protopath[128]	= {"^EKSprototypeMetaclasses>"};
class Template {
public:
	Template()	{}
static	Metaproto*	makeMetaproto(char* class_name)
			{	return new Metaproto(class_name); };
static	Type*		get_x_def_type(Metaproto* mp)
			{	return mp->x_def_type; };
static	Metaproto*	get_proto(char* class_name);
static	void		desc_mp(char* class_name);
};

Metaproto*	Template::get_proto(char* class_name)
{
	strcpy(&protopath[25], class_name);
	Metaproto*   mp = (Metaproto*)OC_lookup(protopath);
	return mp;
};

void	Template::desc_mp(char* class_name)
{
	Metaproto*   mp = get_proto(class_name);

	cout << "    Metaclass Prototype for " << mp->protege_class_name << "\n"
	     << "    base class: " << mp->protege_base_name << "\n"
	     << "    x_def class: " << mp->x_def_class_name << "\n";

	if (mp->callers.size()) {
	     	cout << "    acceptable callers: \n";
		List_iterator(char)	c_iter(&(mp->callers));
		char*	clr;
		while (clr = c_iter(FORWARD))
	     		cout << "        " << clr << "\n";
	};
	if (mp->auxiliaries.size()) {
	     	cout << "    auxiliaries used: \n";
		List_iterator(char)	c_iter(&(mp->auxiliaries));
		char*	clr;
		while (clr = c_iter(FORWARD))
	     		cout << "        " << clr << "\n";
	};
};
			

Type*	X_def_Type_pointer;



main()
{
	OC_open("EKStst");
	OC_transactionStart();

	Directory* pd = (Directory*)OC_lookup("^EKSprototypeMetaclasses");
	if (pd == NULLPTR(Directory)) {
		cout << "Creating the prototype directory\n";
		pd = new Directory("^EKSprototypeMetaclasses");
		pd->putObject(FALSE);
	};

	char	class_name[128];
	cout << "name of new class? ";
	cin >> class_name;

/**** An ONTOS bug makes the following Type OC_lookup cause a memory fault
      when subsequently running a ctor for a class with >1 embedded persistent
      object.  Sometimes interposing another db operation stops the error.

	Type*	class_type = (Type*)OC_lookup(class_name);
	if ( class_type == NULLPTR(Type)  ||
	     class_type->AKO(TYPE_OF(EKSObject)) == FALSE ) {
		char	class_filename[128];
		cout << "filename of .h file? ";
		cin >> class_filename;
		char	cmd[128];
		sprintf(cmd,"classify +RS +F %s\n", class_filename);
		system(cmd);
		class_type = (Type*)OC_lookup(class_name);
	};

****/					// check if Metaproto already exists
	Metaproto*	mp = Template::get_proto(class_name);
	if (mp != NULLPTR(Metaproto)) {
		Template::desc_mp(class_name);
	} else {
		cout << "No Metaproto for " << class_name << "exits\n";
	};

	OC_transactionAbort();
	OC_close();
};
	
