#include	"infrastructure/Metaclass.h"

#include	<string.h>
#include	<stdlib.h>
#include	<ONTOS/ArgumentList.h>
#include	<ONTOS/Procedure.h>
#include	"infrastructure/Template.h"


Type*	Metaclass_Type_pointer;

EKSObject* Metaclass::link_to(char* instance_name)
{	
	DEBUG1	<< "Metaclass::link_to(" << instance_name << ")\n";

	List_iterator(EKSObject)	cls_iter(protege_instances);
	EKSObject*	cls;
	while (cls = cls_iter(FORWARD))
		if (!strcmp(instance_name, cls->name())) 
			return cls;
	cerr << "Metaclass: attempt to link to non existant instance of "
	     << protege_class_name << " - " << instance_name << ")\n";
	return NULLPTR(EKSObject);
};
					     // ARG_NOT_USED
EKSObject* Metaclass::instantiate(Metaclass* /*caller*/, X_def* x_def)
{	
	DEBUG1	<< "Metaclass::instantiate(" << caller->oid() <<", x_def)\n";

					// make another protege instance
				// check x-def is ok
	if (!x_def->getDirectType()->AKO(x_def_type))
		cerr << "Oops, can't use a (" << x_def->getDirectType()->typeName()
		     << " as a " << x_def_class_name << "\n",   exit(1);
//// do we need to runtime check caller type?
	ArgumentList	args;
//	args.setElement(0, NULLPTR(Entity));	// 'this' for new instance
	args.setElement(0, (Entity*)this);
	args.setElement(1, (Entity*)x_def);
	EKSObject*	cls = (EKSObject*)protege_type->Instantiate(&args);

					// keep list of instances for linking to
					// and saving to ONTOS
	protege_instances->append(cls);
	return cls;
};
				   // ARG_NOT_USED
void Metaclass::destroy(Metaclass* /*caller*/, EKSObject* cls)
{	
	DEBUG1	<< "Metaclass::destroy(" << caller->oid() << "", " << object->oid() << ")\n";

	//// should check it is valid object and that it is on the instance list
					// destroy given protege instance
	Procedure*	proc = protege_type->Destructor();
	ArgumentList	args;
	args.setElement(0, (Entity*)cls);    // this for object to be deleted
	(void)proc->Invoke(&args);

					// remove from list of instances
	protege_instances->remove(cls);
};

	
				/* Describe the data required by this class.
				 * Its X-def class will have a static member fn
				 * description() which can be called.
				 */
void	Metaclass::desc_X_def(ostream& s)
{
	DEBUG1	<< "Metaclass::desc_X_def(ostream& s)\n";

				// run the description member function
				//	for protege's x-def;
	ProcedureIterator	proc_iter(x_def_type, "description", NoLock);
	Procedure*	proc = proc_iter();	// assume not overloaded/virtual
	ArgumentList	args;
	args.setElement(0, (Entity*)this);    // me, so fn can access other classes
	args.setElement(1, (void*)(&s));      // stream on which to print
	(void)proc->Invoke(&args);
};

X_def*	Metaclass::make_X_def()
{
	DEBUG1	<< "X_def*   Metaclass::make_X_def()\n";

				// make a new x-def for a protege
	ArgumentList	args;
	args.setElement(0, (Entity*)this);
	X_def*	cls = (X_def*)x_def_type->Instantiate(&args);

					// keep list of instances for saving->ONTOS
	x_def_instances->append(cls);
	return cls;
};

void	Metaclass::save_state(char* savedstate_name)
{
	DEBUG1	<< "Metaclass::save_state(" << savedstate_name << ")\n";

	if (!protege_instances)
		return;

	saved_state = TRUE;
						// save list & instances
	char	pathname[128];
	strcpy(pathname, savedstate_name);		// save in savedstate dir
	protege_instances->dir(pathname);
	strcat(pathname, name());			// use meta name + .Ilist
	strcat(pathname, ".Ilist");
	protege_instances->name(name(), ".Ilist");
	protege_instances->Name(pathname);
	protege_instances->putObject(FALSE);

	save_defs(savedstate_name);
};

void	Metaclass::save_defs(char* dataset_name)
{
	DEBUG1	<< "Metaclass::save_defs(" << dataset_name << ")\n";

	if (!x_def_instances)
		return;
	saved_data = TRUE;
						// save list & instances
	char	path[128];
	strcpy(path, dataset_name);		// save in dataset dir
	x_def_instances->dir(path);
	strcat(path, name());				// use meta name + .Xlist
	strcat(path, ".Xlist");
	x_def_instances->name(name(), ".Xlist");
	x_def_instances->Name(path);
	x_def_instances->putObject(FALSE);
};


static	char	protopath[128]	= {"^EKSprototypeMetaclasses>"};

					/* We want this Metaclass to be a deriv-
					 * ative of the Metaproto for "class_name"
					 * So, retrieve the metaproto and copy its
					 * data into this classes Metaproto base
					 */
Metaproto&	get_proto(char* class_name)
{
	strcpy(&protopath[25], class_name);
	Metaproto*	mp = (Metaproto*)OC_lookup(protopath);
	return *mp;
};

				/* Assumes Metaproto instance already in ONTOS
				 * Note  template knows me as 'notional', so I
				 * will be saved under that name in the
				 * templates ONTOS directory.
				 */
Metaclass::Metaclass(char* class_name, char* notional, Template* tp)
					: Metaproto(get_proto(class_name)),
					  saved_state(FALSE), saved_data(FALSE)
{
	DEBUG	<< "Metaclass::Metaclass" << class_name << ")\n";

	initDirectType(TYPE_OF(Metaclass));

	name(notional);
					// save ptr to template so we can access
					//	other metaclasses at runtime.
	the_template = tp;
					// create list for proteges & x-defs
	protege_instances = new List(EKSObject);
	x_def_instances = new List(X_def);
};

Metaclass::Metaclass(APL* theAPL) : Metaproto(theAPL)
{
	DEBUG << "Metaclass::Metaclass(APL* theAPL)\n";
					// retrieve instance & def lists from ONTOS
	if (saved_state)   RETRIEVE(protege_instances);
	else		protege_instances = new List(EKSObject);
	if (saved_data)    RETRIEVE(x_def_instances);
	else		x_def_instances = new List(X_def);
};

Metaclass::~Metaclass()
{
	Destroy(FALSE);
};

void	Metaclass::Destroy(Boolean aborted)
{
	DEBUG << "Metaclass::Destroy(" << aborted? "TRUE" : "FALSE" << ")\n";

	delete protege_instances;	// delete the list, not the instances
	delete x_def_instances;

	if(aborted)
		Metaproto::Destroy(aborted);
};

					// save the Metaclass in the Template
void	Metaclass::putObject(Boolean deallocate)
{
	DEBUG1 << "Metaclass::putObject(" << deallocate? "TRUE" : "FALSE" << ")\n";
					// Metaclass id saved in template directory
	char	path[128];
	dir(the_template->dir());	// save in same dir as owning Template
	strcpy(path, dir());
	strcat(path, name());
	Name(path);

	if (saved_state)   STORE(protege_instances);
	if (saved_data)    STORE(x_def_instances);
	EKSObject::putObject(deallocate);
};

					// delete the Metaclass from Template dir
void	Metaclass::deleteObject(Boolean deallocate)
{
	DEBUG1 << "Metaclass::deleteObject(" << deallocate? "TRUE" : "FALSE" << ")\n";

	if (saved_state)   FORGET(protege_instances);
	if (saved_data)    FORGET(x_def_instances);
	EKSObject::deleteObject(deallocate);
};

					// classname is 'notional' name of class
EKSObject* Metaclass::link_to(char* classname, char* instance_name)
{	
	DEBUG1	<< "Metaclass::link_to(" << classname << ", " << instance_name << ")\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	return (meta ? meta->link_to(instance_name) : NULLPTR(EKSObject));	
};

					// classname is 'notional' name of class
EKSObject* Metaclass::make_a(char* classname, X_def* x_def)
{	
	DEBUG1	<< "Metaclass::make_a(" << classname << ", x_def)\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	return (meta ? meta->instantiate(this, x_def) : NULLPTR(EKSObject));	
}

					// classname is 'notional' name of class
void	Metaclass::destroy(char* classname, EKSObject* object)
{	
	DEBUG1	<< "Metaclass::destroy(" << classname << ", x_def)\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	meta->destroy(this, object);	
}

					// classname is 'notional' name of class
void	Metaclass::describe_def_for(char* classname, ostream& s)
{
	DEBUG1	<< "Meta_site_sun::describe_def_for(char* classname)\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	if(meta)   meta->desc_X_def(s);
};

					// classname is 'notional' name of class
X_def* Metaclass::make_def_for(char* classname)
{	
	DEBUG1	<< "Metaclass::make_def_for(" << classname << ")\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	return (meta ? meta->make_X_def() : NULLPTR(X_def));	
};



template_implement(List,EKSObject);
template_implement(List,X_def);
