#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/EKSObject.h"


Type*	EKSObject_Type_pointer;

EKSObject::EKSObject(Metaclass* meta) : Object()
{
	initDirectType(TYPE_OF(EKSObject));

	i_name = i_dir = NULLPTR(char);
	metaclass = meta;
};

EKSObject::EKSObject(APL* theAPL) : Object(theAPL)
{};

EKSObject::~EKSObject()
{
	Destroy(FALSE);
};

void	EKSObject::Destroy(Boolean aborted)
{
	if (i_name)	free(i_name);
	if (i_dir)	free(i_dir);

	if (aborted)
		Object::Destroy(aborted);
};


EKSObject&	EKSObject::operator=(EKSObject& e)
{
	if (&e == this)   return *this;

	metaclass = e.metaclass;

	return *this;
};

#ifdef DEBUGoid
char*	EKSObject::oid()
{
	char* s = malloc(strlen(i_name)+8);
	strcpy(s, i_name);
	strcat(s, "<");
	strcat(s, l64a((long)this));
	strcat(s, ">");
	return s;
};
# else
char*	EKSObject::oid()
{
	return i_name;
};
#endif


