#ifndef Dimension_H
#define Dimension_H

#include	<stream.h>
#include	"infrastructure/EKS.h"		// for defn of Boolean
class	APL;


class Dimension
{
protected:
  float aValue;

public:
  Dimension(const float v);
  Dimension(const Dimension& v);
  Dimension(); 				// default constructor does nothing
  Dimension(APL* theAPL); 		// oodb reload constructor does nothing
  float value() const {return aValue;}	//and converts to float
  void setValue(const float val) { aValue=val; }
  Dimension operator=(const  Dimension arg);
  Dimension operator+=(const  Dimension arg);
  Dimension operator-=(const  Dimension arg);
friend  Boolean operator==(const Dimension arg, const Dimension arg);
friend  Boolean operator!=(const Dimension arg, const Dimension arg);
friend  Boolean operator<=(const Dimension arg, const Dimension arg);
friend  Boolean operator>=(const Dimension arg, const Dimension arg);
friend  Boolean operator<(const Dimension arg, const Dimension arg);
friend  Boolean operator>(const Dimension arg, const Dimension arg);
friend  Dimension operator+(const Dimension arg, const Dimension arg);
friend  Dimension operator-(const Dimension arg, const Dimension arg);
friend  Dimension operator/(const Dimension arg, const Dimension arg);
friend  Dimension operator*(const Dimension arg, const Dimension arg);
  friend ostream& operator <<(ostream&, const Dimension);
  void whatClass() const;
};

#endif
