#include	"dimensions/Dimension.h"


Dimension::Dimension (const float v)
{
  aValue=v;
}

Dimension::Dimension (const Dimension& v)
{
  aValue=v.value();
}
 

Dimension::Dimension (APL* theAPL)
{}

Dimension::Dimension ()
{
 // does nothing
}

Dimension Dimension::operator=(const  Dimension arg)
{        
         if(this==&arg) return (*this);
         aValue = arg.value();
         return (*this);
}

Dimension Dimension::operator+=(const  Dimension arg)
{        
         if(this==&arg) return (*this);
         aValue += arg.value();
         return (*this);
}

Dimension Dimension::operator-=(const  Dimension arg)
{        
         if(this==&arg) return (*this);
         aValue -= arg.value();
         return (*this);
}

Boolean operator==(const  Dimension arg1,  const Dimension arg2)
{
        return (arg1.aValue == arg2.aValue);
}

Boolean operator!=(const  Dimension arg1,  const Dimension arg2)
{
        return (arg1.aValue != arg2.aValue);
}

Boolean operator<=(const  Dimension arg1,  const Dimension arg2)
{
        return (arg1.aValue <= arg2.aValue);
}

Boolean operator>=(const  Dimension arg1,  const Dimension arg2)
{
        return (arg1.aValue >= arg2.aValue);
}

Boolean operator<(const  Dimension arg1,  const Dimension arg2)
{
        return (arg1.aValue < arg2.aValue);
}

Boolean operator>(const  Dimension arg1,  const Dimension arg2)
{
        return (arg1.aValue > arg2.aValue);
}

Dimension operator+(const  Dimension arg1,  const Dimension arg2)
{
        return arg1.aValue + arg2.aValue;
}

Dimension operator-(const  Dimension arg1,  const Dimension arg2)
{
        return arg1.aValue - arg2.aValue;
}

Dimension operator*(const  Dimension arg1, const Dimension arg2)
{
        return arg1.aValue * arg2.aValue;
}

Dimension operator/(const  Dimension arg1, const Dimension arg2)
{
        return  arg1.aValue / arg2.aValue;
}

ostream& operator <<(ostream& strm, const Dimension r)
{
        return strm << r.aValue;
 
}

void Dimension::whatClass() const
{
        cout << "I'm really a Dimension! \n";
}
