#include	"infrastructure/Template.h"
#include	"infrastructure/Metaclass.h"


Metaclass*	make_meta_for(char* classname, Template* tp)
{
	DEBUG1	<<"make_a_meta(" << classname <<", " << tp->oid() <<")\n";

#ifdef	DEMO1
	if (!strcmp(classname, "Context_1a")) {
		static char*	context_1a_caller_types[] = {
							0 };
		static char*	context_1a_aux_classes[] = {
							"Site_basic",
							0 };
		return (Metaclass*) new Metaclass(
				"Context", "Context_1a", "Context_1a_def",
				context_1a_caller_types, context_1a_aux_classes,
				tp);
	} else if (!strcmp(classname, "Site_basic")) {
		static char*	site_caller_types[] =	{
							0 };
		static char*	site_aux_classes[] = 	{
							"Climate_met",
							0 };
		return (Metaclass*) new Metaclass(
				"Site", "Site_basic", "Site_basic_def",
				site_caller_types, site_aux_classes,
				tp);
	} else if (!strcmp(classname, "Climate_met")) {
		static char*	climate_caller_types[] = {
							0 };
		static char*	climate_aux_classes[] = {
							0 };
		return (Metaclass*) new Metaclass(
				"Climate", "Climate_met", "Climate_met_def",
				climate_caller_types, climate_aux_classes,
				tp);
	} else if (!strcmp(classname, "Context_1b")) {
		static char*	context_1b_caller_types[] = {
							0 };
		static char*	context_1b_aux_classes[] = {
							"Site_sun",
							0 };
		return (Metaclass*) new Metaclass(
				"Context", "Context_1b", "Context_1b_def",
				context_1b_caller_types, context_1b_aux_classes,
				tp);
	} else if (!strcmp(classname, "Site_sun")) {
		static char*	site_sun_caller_types[] = {
							0 };
		static char*	site_sun_aux_classes[] = {
							"Climate_met",
							"Sun_basic",
							"Sky_basic",
							0 };
		return (Metaclass*) new Metaclass(
				"Site", "Site_sun", "Site_sun_def",
				site_sun_caller_types, site_sun_aux_classes,
				tp);
	} else if (!strcmp(classname, "Sun_basic")) {
		static char*	sun_caller_types[] =	{
							0 };
		static char*	sun_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Sun", "Sun_basic", "Sun_basic_def",
				sun_caller_types, sun_aux_classes,
				tp);
	} else if (!strcmp(classname, "Sky_basic")) {
		static char*	sky_caller_types[] =	{
							0 };
		static char*	sky_aux_classes[] =	{
							"Sky_irradiance",
							"Sky_termperature",
							0 };
		return (Metaclass*) new Metaclass(
				"Sky", "Sky_basic", "Sky_basic_def",
				sky_caller_types, sky_aux_classes,
				tp);
	} else if (!strcmp(classname, "Perez")) {
		static char*	perez_caller_types[] =	{
							0 };
		static char*	perez_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Sky_irradiance", "Perez", "Perez_def",
				perez_caller_types, perez_aux_classes,
				tp);
	} else if (!strcmp(classname, "Berdahl_and_Martin")  ||
	         !strcmp(classname, "B&M")) {
		static char*	bandm_caller_types[] =	{
							0 };
		static char*	bandm_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Sky_temperature", "Berdahl_and_Martin", "Berdahl_and_Martin_def",
				bandm_caller_types, bandm_aux_classes,
				tp);
#ifdef DEMO2
	} else if (!strcmp(classname, "Context_2a")) {
		static char*	context_2a_caller_types[] =	{
							0 };
		static char*	context_2a_aux_classes[] =	{
						        "Site_basic",
						        "Construction_basic",
							0 };
		return (Metaclass*) new Metaclass(
				"Context", "Context_2a", "Context_2a_def",
				context_2a_caller_types, context_2a_aux_classes,
				tp);
	} else if (!strcmp(classname, "Construction_basic")) {
		static char*	construction_basic_caller_types[] =	{
							0 };
		static char*	construction_basic_aux_classes[] =	{
						        "Surface_basic",
						        "Layer_basic",
							0 };
		return (Metaclass*) new Metaclass(
				"Construction", "Construction_basic", "Construction_basic_def",
				construction_basic_caller_types, construction_basic_aux_classes,
				tp);
	} else if (!strcmp(classname, "Surface_basic")) {
		static char*	surface_basic_caller_types[] =	{
							0 };
		static char*	surface_basic_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Surface", "Surface_basic", "Surface_basic_def",
				surface_basic_caller_types, surface_basic_aux_classes,
				tp);
	} else if (!strcmp(classname, "Layer_basic")) {
		static char*	layer_basic_caller_types[] =	{
							0 };
		static char*	layer_basic_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Layer", "Layer_basic", "Layer_basic_def",
				layer_basic_caller_types, layer_basic_aux_classes,
				tp);
	} else if (!strcmp(classname, "Context_2b")) {
		static char*	context_2b_caller_types[] =	{
							0 };
		static char*	context_2b_aux_classes[] =	{
						        "Site_basic",
						        "Construction_es",
							"Conduction_fd",
						        "Solver",
							0 };
		return (Metaclass*) new Metaclass(
				"Context", "Context_2b", "Context_2b_def",
				context_2b_caller_types, context_2b_aux_classes,
				tp);
	} else if (!strcmp(classname, "Construction_es")) {
		static char*	construction_es_caller_types[] = {
							0 };
		static char*	construction_es_aux_classes[] =	{
						        "Surface_es",
						        "Layer_es",
							0 };
		return (Metaclass*) new Metaclass(
				"Construction", "Construction_es", "Construction_es_def",
				construction_es_caller_types, construction_es_aux_classes,
				tp);
	} else if (!strcmp(classname, "Surface_es")) {
		static char*	surface_es_caller_types[] =	{
							"Construction_es",
							0 };
		static char*	surface_es_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Surface", "Surface_es", "Surface_es_def",
				surface_es_caller_types, surface_es_aux_classes,
				tp);
	} else if (!strcmp(classname, "Layer_es")) {
		static char*	layer_es_caller_types[] =	{
							0 };
		static char*	layer_es_aux_classes[] =	{
						        "Conduction",
							0 };
		return (Metaclass*) new Metaclass(
				"Layer", "Layer_es", "Layer_es_def",
				layer_es_caller_types, layer_es_aux_classes,
				tp);
	} else if (!strcmp(classname, "Conduction_fd")) {
		static char*	conduction_fd_caller_types[] =	{
							0 };
		static char*	conduction_fd_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Conduction", "Conduction_fd", "Conduction_fd_def",
				conduction_fd_caller_types, conduction_fd_aux_classes,
				tp);
	} else if (!strcmp(classname, "Gauss_column_pivot")) {
		static char*	gauss_column_pivot_caller_types[] = {
							0 };
		static char*	gauss_column_pivot_aux_classes[] = {
							0 };
		return (Metaclass*) new Metaclass(
				"Solver", "Gauss_column_pivot", "Gauss_column_pivot_def",
				gauss_column_pivot_caller_types, gauss_column_pivot_aux_classes,
				tp);
#ifdef DEMO3
	} else if (!strcmp(classname, "Context_3a")) {
		static char*	context_3a_caller_types[] = {
							0 };
		static char*	context_3a_aux_classes[] = {
							"Site_sun",
							"Building",
							0 };
		return (Metaclass*) new Metaclass(
				"Context", "Context_3a", "Context_3a_def",
				context_3a_caller_types, context_3a_aux_classes,
				tp);
	} else if (!strcmp(classname, "Building")) {
		static char*	building_caller_types[] = {
							0 };
		static char*	building_aux_classes[] = {
							"Room",
							"Construction",
							0 };
		return (Metaclass*) new Metaclass(
				"Building", "Building", "Building_def",
				building_caller_types, building_aux_classes,
				tp);
	} else if (!strcmp(classname, "Space")) {
		static char*	space_caller_types[] = {
							0 };
		static char*	space_aux_classes[] = {
							"AirVolume",
							0 };
		return (Metaclass*) new Metaclass(
				"Space", "Space", "Space_def",
				space_caller_types, space_aux_classes,
				tp);
	} else if (!strcmp(classname, "Room")) {
		static char*	room_caller_types[] = {
							"Building",
							0 };
		static char*	room_aux_classes[] = {
							"AirVolume",
							"HeatSource",
							0 };
		return (Metaclass*) new Metaclass(
				"Room", "Room", "Room_def",
				room_caller_types, room_aux_classes,
				tp);
	} else if (!strcmp(classname, "AirVolume")) {
		static char*	airVolume_caller_types[] = {
							"Room",
							0 };
		static char*	airVolume_aux_classes[] = {
							0 };
		return (Metaclass*) new Metaclass(
				"AirVolume", "AirVolume", "AirVolume_def",
				airVolume_caller_types, airVolume_aux_classes,
				tp);
	} else if (!strcmp(classname, "HeatSource")) {
		static char*	heatSource_caller_types[] = {
							0 };
		static char*	heatSource_aux_classes[] = {
							0 };
		return (Metaclass*) new Metaclass(
				"HeatSource", "HeatSource", "HeatSource_def",
				heatSource_caller_types, heatSource_aux_classes,
				tp);
	} else if (!strcmp(classname, "Context_3b")) {
		static char*	context_3b_caller_types[] = {
							0 };
		static char*	context_3b_aux_classes[] = {
							"Site_sun",
							"Building_es",
							"Convection_fd_1",
						        "Radiation_fd_1",
							0 };
		return (Metaclass*) new Metaclass(
				"Context", "Context_3b", "Context_3b_def",
				context_3b_caller_types, context_3b_aux_classes,
				tp);
	} else if (!strcmp(classname, "Building_es")) {
		static char*	building_es_caller_types[] = {
							0 };
		static char*	building_es_aux_classes[] = {
							"Room_es",
							"Construction_es",
							0 };
		return (Metaclass*) new Metaclass(
				"Building", "Building_es", "Building_es_def",
				building_es_caller_types, building_es_aux_classes,
				tp);
	} else if (!strcmp(classname, "Room_es")) {
		static char*	room_es_caller_types[] = {
							"Building_es",
							0 };
		static char*	room_es_aux_classes[] = {
							"AirVolume_es",
							"HeatSource",
							0 };
		return (Metaclass*) new Metaclass(
				"Room", "Room_es", "Room_es_def",
				room_es_caller_types, room_es_aux_classes,
				tp);
	} else if (!strcmp(classname, "AirVolume_es")) {
		static char*	airVolume_es_caller_types[] = {
							"Room_es",
							0 };
		static char*	airVolume_es_aux_classes[] = {
							0 };
		return (Metaclass*) new Metaclass(
				"AirVolume", "AirVolume_es", "AirVolume_es_def",
				airVolume_es_caller_types, airVolume_es_aux_classes,
				tp);
	} else if (!strcmp(classname, "Convection_fd_1")) {
		static char*	convection_fd_1_caller_types[] ={
							0 };
		static char*	convection_fd_1_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Convection", "Convection_fd_1", "Convection_fd_1_def",
				convection_fd_1_caller_types, convection_fd_1_aux_classes,
				tp);
	} else if (!strcmp(classname, "Radiation_fd_1")) {
		static char*	radiation_fd_1_caller_types[] ={
							0 };
		static char*	radiation_fd_1_aux_classes[] =	{
							0 };
		return (Metaclass*) new Metaclass(
				"Radiation", "Radiation_fd_1", "Radiation_fd_1_def",
				radiation_fd_1_caller_types, radiation_fd_1_aux_classes,
				tp);
#endif	DEMO3
#endif	DEMO2
	};
#endif	DEMO1

	cerr << "make_meta_for: don't know how to make metaclass for "<< classname <<"\n";
	return NULLPTR(Metaclass);
};
