#ifndef TEMPLATE_H
#define TEMPLATE_H

#include	<string.h>
#include	<ctype.h>
#include	"infrastructure/EKSObject.h"
#include	"infrastructure/Metaclass.h"
class	Context;
class	Context_def;
#include	"infrastructure/list.h"
template_define(List,Metaclass);


extern Type*	Template_Type_pointer;

class Template : public EKSObject {
protected:
friend	Metaclass;
	List(Metaclass)*	m_cls_list;

	Metaproto*	get_proto(char* class_name);
	void		setup(char* notional);
	Metaclass*	get_meta_for(char* classname);
public:
	Template();
	Template(APL* theAPL);
	Template(char* template_name);
	~Template();
	Type*	getDirectType();
	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);

	void		dump(char* filename);
	void		load(char* filename);
	void		desc_data(ostream& s);
	Context_def*	build_data();
	void		save_data(char* dataset_name);
	Context*	build_prog(Context_def* x_def);
};


inline
Type*	Template::getDirectType()
{
	return TYPE_OF(Template);
};

#endif
