#ifndef META_P_H
#define META_P_H

#include	"infrastructure/EKSObject.h"
class  Metaproto;
#include	"infrastructure/list.h"
template_define(List,char);

extern	Type*	Metaproto_Type_pointer;

class  Metaproto : public EKSObject {
protected:
friend	Template;
friend	Metaproto* mk_proto(char* class_name);
	Metaproto(Metaproto& mp);		// used by Metaclass ctor
	char*			protege_class_name;
	Type*			protege_type;
	char*			protege_base_name;
	char*			x_def_class_name;
	Type*			x_def_type;
	List(char)*		callers;
	List(char)*		auxiliaries;


	Metaproto(char* class_name);
	Metaproto(char* class_name, char* base_name, char* x_def_name,
					char** caller_types, char** aux_classes);
	Metaproto(APL*	theAPL);
	~Metaproto();
	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);

public:
	Type*	getDirectType();

	Boolean			ako(char* class_name);
	Boolean			check_ok_for(Metaproto* caller);
	virtual	char**		auxiliary_classes();
};

inline
Type*	Metaproto::getDirectType()
{
	return TYPE_OF(Metaproto);
};
	
#endif
