#include	"infrastructure/Metaproto.h"

#include	<string.h>
#include	<stdlib.h>
#include	"context/X_def.h"

Type*	Metaproto_Type_pointer;


					/* this protected ctor is used by Metaclass
					 * to ctor its base class to the data
					 * given in the prototype created by
					 * standalone routine ::mk_proto(name)
					 */
Metaproto::Metaproto(Metaproto& mp)	: EKSObject(NULLPTR(Metaclass))
{
	DEBUG	<< "Metaproto::Metaproto(Metaproto& mp))\n";

	dir(PROTOPATH);
	name(mp.protege_class_name);

	protege_class_name = strdup(mp.protege_class_name);
	protege_type = mp.protege_type;
	protege_base_name = strdup(mp.protege_base_name);
	x_def_class_name = strdup(mp.x_def_class_name);
	x_def_type = mp.x_def_type;
	callers = new List(char)(*mp.callers);
	auxiliaries = new List(char)(*mp.auxiliaries);
};


				/* Make a prototype Metaclass
				 */
Metaproto::Metaproto(char* class_name)  : EKSObject(NULLPTR(Metaclass))
{
	DEBUG	<< "Metaproto::Metaproto(" << class_name << ")\n";

					//// should check class exists & is ok
	protege_class_name = strdup(class_name);

	char	protopath[128];
	strcpy(protopath, PROTOPATH);
	dir(protopath);
	strcpy(protopath, class_name);

					//// should check if prototype exists
	name(class_name);
	Name(protopath);			// set name to full pathname

						// set name of EKS base class
	static	char	buff[128];
	cout << "EKS class for which " << class_name << " is a variant >";
	cin >> buff;
					//// should check base class exists & is ok
	protege_base_name = strdup(buff);

						// set name of reqd X-def class
	cout << "What x-def class is used by " << class_name << " >";
	cin >> buff;
					//// should check class_def exists & is ok
	x_def_class_name = strdup(buff);

					// now capture usage info
	callers = new List(char);
	cout << "If " << class_name << " calls member functions in the class\n"
	     << "which invokes it, give a list of acceptable callers\n"
	     <<  "otherwise (ie a null list) any caller is deemed acceptable\n"
	     << "\t\t(terminate list with '.')\n\t> ";
	char	a_caller_typename[128];
	cin >> a_caller_typename;
	while (strlen(a_caller_typename) != 0  &&  *a_caller_typename != '.') {
					//// should check class exists & is ok
		callers->append(strdup(a_caller_typename));
		cout << "\t> ";
		cin >> a_caller_typename;
	};


	auxiliaries = new List(char);
	cout << "If " << class_name << " invokes (instantiates) other classes\n"
	     << "to support it, give a list of those classes\n"
	     << "\t\t(terminate list with '.')\n\t> ";
	char	a_aux_typename[128];
	cin >> a_aux_typename;
	while (strlen(a_aux_typename) != 0  &&  *a_aux_typename != '.') {
					//// should check class exists & is ok
		auxiliaries->append(strdup(a_aux_typename));
		cout << "\t> ";
		cin >> a_aux_typename;
	};	

	initDirectType(getDirectType());
					//// should write out proto defn to file
};

Metaproto::Metaproto(char* class_name, char* base_name, char* x_def_name,
					char** caller_types, char** aux_classes)
					: EKSObject(NULLPTR(Metaclass))
{
	DEBUG	<< "Metaproto::Metaproto(" << class_name << ")\n";

	protege_type = new Type(class_name);

	char	protopath[128];
	strcpy(protopath, PROTOPATH);
	dir(protopath);
	strcpy(protopath, class_name);
	protege_class_name = strdup(class_name);

	name(class_name);
	Name(protopath);			// set name to full pathname

						// set name of EKS base class
	protege_base_name = strdup(base_name);

						// set name of reqd X-def class
	x_def_class_name = strdup(x_def_name);

					// now capture usage info
	callers = new List(char);
	int c;
	for (c=0; caller_types[c] != NULLPTR(char); c++)
		callers->append(strdup(caller_types[c]));


	auxiliaries = new List(char);
	for (c=0; aux_classes[c] != NULLPTR(char); c++)
		auxiliaries->append(aux_classes[c]);

	initDirectType(getDirectType());
};	

Metaproto::Metaproto(APL* theAPL) : EKSObject(theAPL)
{
	DEBUG << "Metaproto::Metaproto(APL* theAPL)\n";

	cerr << "In solo mode, attempted to retrieve Metaproto from an oodb!!\n\n";
	exit(1);
};

Metaproto::~Metaproto()
{
	DEBUG << "Metaproto::~Metaproto()\n";

	Destroy(FALSE);
};

void	Metaproto::Destroy(Boolean aborted)
{
	DEBUG << "Metaproto::Destroy(Boolean aborted)\n";

	delete protege_class_name;
	delete protege_base_name;
	delete x_def_class_name;

	delete callers;
	delete auxiliaries;
	callers = auxiliaries = NULLPTR(List(char));
	
	if(aborted)
		EKSObject::Destroy(aborted);
};


				     /* ARG NOT USED */
void	Metaproto::putObject(Boolean /*deallocate*/)
{
	DEBUG << "Metaproto::putObject(Boolean deallocate)\n";

	cerr << "In solo mode, attempted to store Metaproto into an oodb!!\n\n";
	exit(1);
};

					/* ARG NOT USED */
void	Metaproto::deleteObject(Boolean /*deallocate*/)
{
	DEBUG << "Metaproto::deleteObject(Boolean deallocate)\n";

	cerr << "In solo mode, attempted to delete Metaproto from an oodb!!\n\n";
	exit(1);
};


Boolean Metaproto::check_ok_for(Metaproto* the_caller)
{
	DEBUG1	<< "Boolean Metaproto::check_ok_for(Metaproto* caller)\n";
				// check caller has everything this needs
	if (callers->size() == 0)
		return TRUE;			// no restrictions

	List_iterator(char)	clr_iter(callers);
	char*	clr;
	while (clr = clr_iter(FORWARD))
		if (!strcmp(the_caller->protege_type->typeName(), clr))
			return TRUE;
	return FALSE;
};


char**	Metaproto::auxiliary_classes()
{
	DEBUG1	<< "Metaproto::auxiliary_classes()\n";

						// from reqd functions, get list
						//	of aux classes to ask for
	int	sz = auxiliaries->size();

	char**	aux_fns_classes = (char**)malloc((sz+1) * sizeof(char*));
	aux_fns_classes[sz] = NULLPTR(char);

	if (sz == 0)
		return aux_fns_classes;

	List_iterator(char)	aux_iter(auxiliaries);
	char*	str;
	int	i = 0;
	while (str = aux_iter(FORWARD))
		aux_fns_classes[i++] = strdup(str);
	return aux_fns_classes;
};



template_implement(List,char);
