#include	"infrastructure/Metaclass.h"

#include 	<string.h>
#include	<stdlib.h>
#include	"infrastructure/Template.h"


Type*	Metaclass_Type_pointer;
extern	EKSObject*	instantiate(char* class_name, Metaclass* caller);
extern	EKSObject*	instantiate(char* class_name, Metaclass* caller,
				    X_def* def);
extern	void		destroy(char* class_name, EKSObject* cls);
extern	void		desc_def_for(char* class_name, Metaclass* caller,
				     ostream& s);

EKSObject* Metaclass::link_to(char* instance_name)
{	
	DEBUG1	<< "Metaclass::link_to(" << instance_name << ")\n";

	List_iterator(EKSObject)	cls_iter(protege_instances);
	EKSObject*	cls;
	while (cls = cls_iter(FORWARD))
		if (!strcmp(instance_name, cls->name())) 
			return cls;
	cerr << "Metaclass: attempt to link to non existant instance of "
	     <<  protege_class_name << " - " << instance_name << ")\n";
	return NULLPTR(EKSObject);
};

					     /* ARG NOT USED */
EKSObject* Metaclass::instantiate(Metaclass* /*caller*/, X_def* x_def)
{	
	DEBUG1	<< "Metaclass::instantiate(" << caller->oid() <<", x_def)\n";

					// make another protege instance
////				// check x-def is ok
////	if (!x_def->getDirectType()->AKO(x_def_type))
////		cerr << "Oops, can't use a (" << x_def->getDirectType()->typeName()
////		     << " as a " << x_def_class_name << "\n",   exit(1);
//// do we need to runtime check caller type?

				// new X(this, (X_def*)x_def);
////	protege_type->Instantiate(this, (X_def*)x_def); // or similar
	EKSObject*	cls = ::instantiate(protege_class_name,
							this, (X_def*)x_def);

	protege_instances->append(cls);
	return cls;
}

				   // ARG_NOT_USED
void Metaclass::destroy(Metaclass* /*caller*/, EKSObject* cls)
{	
	DEBUG1	<< "Metaclass::destroy(" << caller->oid() << "", " << object->oid() << ")\n";

	//// should check it is valid object and that it is on the instance list
					// destroy given protege instance
////	protege_type->Destructor(); // or similar
	::destroy(protege_class_name, cls);
					// remove from list of instances
	protege_instances->remove(cls);
};
	

				/* Describe the data required by this class.
				 * Its X-def class will have a static member fn
				 * description() which can be called.
				 */
void	Metaclass::desc_X_def(ostream& s)
{
	DEBUG1	<< "Metaclass::make_X_def()\n";

				// run the description member function
				//	for protege's x-def;
	//// should check it is valid object and that it is on the instance list
////	x_def_type->Invoke("description", ); // or similar
	::desc_def_for(x_def_class_name, this, s);
}

X_def*	Metaclass::make_X_def()
{
	DEBUG1	<< "Metaclass::make_X_def()\n";

				// return new X_def(this);
////	my_x_def_type->Instantiate(this); // or similar
	X_def*	cls = (X_def*)::instantiate(x_def_class_name, this);

					// keep list of instances for saving->ONTOS
	x_def_instances->append(cls);
	return cls;
}

				    /* ARG NOT USED */
void	Metaclass::save_state(char* /*savedstate_name*/)
{
	DEBUG1	<< "Metaclass::save_state(" << savedstate_name << ")\n";

	cerr << "In solo mode, attempted to save program state into an oodb!!\n\n";
	exit(1);
};

				    /* ARG NOT USED */
void	Metaclass::save_defs(char* /*dataset_name*/)
{
	DEBUG1	<< "Metaclass::save_defs(" << dataset_name << ")\n";

	cerr << "In solo mode, attempted to save product model into an oodb!!\n\n";
	exit(1);
};


					/* We want this Metaclass to be a deriv-
					 * ative of the Metaproto for "class_name"
					 * So, retrieve the metaproto and copy its
					 * data into this classes Metaproto base
					 */
Metaproto&	Metaclass::get_proto(char* class_name)
{
						//standalone routine to run ctor						//  << replaces oodb lookup >>
	Metaproto*	mp = (Metaproto*)::mk_proto(class_name);
	return *mp;
};

				/* Assumes Metaproto instance available from
				 * standalone routine ::mk_proto(name)
				 * Note  template knows me as 'notional', so I
				 * will be saved under that name in the
				 * templates ONTOS directory.
				 */
Metaclass::Metaclass(char* class_name, char* notional, Template* tp)
		    			: Metaproto(get_proto(class_name)),
					  saved_state(FALSE), saved_data(FALSE)

{
	DEBUG	<< "Metaclass::Metaclass" << class_name << ")\n";

	initDirectType(TYPE_OF(Metaclass));

	name(notional);
					// save ptr to template so we can access
					//	other metaclasses at runtime.
	the_template = tp;
					// create list for proteges & x-defs
	protege_instances = new List(EKSObject);
	x_def_instances = new List(X_def);
};

			  /* ARG NOT USED */
Metaclass::Metaclass(APL* theAPL) : Metaproto(theAPL)
{
	DEBUG << "Metaclass::Metaclass(APL* theAPL)\n";
					// retrieve instance & def lists from ONTOS

	cerr << "In solo mode, attempted to retrieve Metaclass from an oodb!!\n\n";
	exit(1);
};


Metaclass::~Metaclass()
{
	Destroy(FALSE);
};

void	Metaclass::Destroy(Boolean aborted)
{
	DEBUG << "Metaclass::Destroy(" << aborted? "TRUE" : "FALSE" << ")\n";

	delete protege_instances;	// delete the List, not the instances
	delete x_def_instances;

	if(aborted)
		Metaproto::Destroy(aborted);
};

				     /* ARG NOT USED */
void	Metaclass::putObject(Boolean /*deallocate*/)
{
	DEBUG1 << "Metaclass::Destroy(" << deallocate? "TRUE" : "FALSE" << ")\n";
					// Metaclass id saved in template directory
	cerr << "In solo mode, attempted to store Metaclass into an oodb!!\n\n";
	exit(1);
};

					// delete the Metaclass from Template dir
					/* ARG NOT USED */
void	Metaclass::deleteObject(Boolean /*deallocate*/)
{
	DEBUG1 << "Metaclass::Destroy(" << deallocate? "TRUE" : "FALSE" << ")\n";

	cerr << "In solo mode, attempted to delete Metaclass from an oodb!!\n\n";
	exit(1);
};


					// classname is 'notional' name of class
EKSObject* Metaclass::link_to(char* classname, char* instance_name)
{	
	DEBUG1	<< "Metaclass::link_to(" << classname << ", " << instance_name << ")\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	return (meta ? meta->link_to(instance_name) : NULLPTR(EKSObject));	
};

					// classname is 'notional' name of class
EKSObject* Metaclass::make_a(char* classname, X_def* x_def)
{	
	DEBUG1	<< "Metaclass::make_a(" << classname << ", x_def)\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	return (meta ? meta->instantiate(this, x_def) : NULLPTR(EKSObject));	
};

					// classname is 'notional' name of class
void	Metaclass::destroy(char* classname, EKSObject* object)
{	
	DEBUG1	<< "Metaclass::destroy(" << classname << ", object)\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	meta->destroy(this, object);	
};

					// classname is 'notional' name of class
void	Metaclass::describe_def_for(char* classname, ostream& s)
{
	DEBUG1	<< "Metaclass::describe_def_for(char* classname, ostream& s)\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	if(meta)   meta->desc_X_def(s);
};

					// classname is 'notional' name of class
X_def* Metaclass::make_def_for(char* classname)
{	
	DEBUG1	<< "Metaclass::make_def_for(" << classname << ")\n";

	Metaclass* meta = the_template->get_meta_for(classname);

	return (meta ? meta->make_X_def() : NULLPTR(X_def));	
};



template_implement(List,EKSObject);
template_implement(List,X_def);
