#ifndef	EKSOBJECT_H
#define	EKSOBJECT_H

#ifdef DEBUG
#define DEBUGoid
#endif

#include	"infrastructure/EKS.h"


class	Metaclass;
class	X_def;

class	Type{
protected:
	char*	name;
public:
	Type(char* class_name);
	Type(Type& type);
	Type(APL* theAPL);
	~Type();

	Type&	operator=(Type& t);
	Boolean		operator==(Type& t);

	char*		typeName();
	Boolean		AKO(Type* t);
};

inline
Type::Type(Type& t)
{};

inline
Type::~Type()
{
	free(name);
};

inline
char*	Type::typeName()
{
	return	name;
};

inline
Boolean	Type::AKO(Type* t)
{
	DEBUG << "assuming " << t.name << " is a derived class of " << name << "\n";

	t = t;
	return TRUE;
};

class EKSObject {
protected:
	char*			i_dir;		// directory where instance saved
	char*			i_name;		// name of instance
	Type*			i_type;		// type of instance
	Metaclass*		metaclass;	// instance classes Metaclass

	EKSObject(Metaclass* meta);
	EKSObject(APL* theAPL);
	~EKSObject();

	void	Destroy(Boolean aborted);
 	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
	void	directType(Type* t);
	void	initDirectType(Type* t);
	void	initDirectType(char* t);
	Type*	getDirectType();

	EKSObject&	operator=(EKSObject& s);

	void		Name(char* fullname);
	void		dir(char* pathname);
	void		name(char* instancename);
	void		name(char* classname, char* instancename);
public:
	char*		Name();
	char*		dir();
	char*		name();
	virtual	char*	oid();
};



inline
void	EKSObject::initDirectType(char* t)
{
	i_type=new Type(t);
};

/***inline
 ***void	EKSObject::initDirectType(Type* t)
 ***{
 ***	i_type = new Type(t->typeName());
 ***};
 ***/
inline
Type*	EKSObject::getDirectType()
{
	return i_type;
};

inline
char*	EKSObject::Name()
{
	return i_name;
};

/***inline
void	EKSObject::Name(char* fullname)
 ***{
 ***	if (i_name == NULLPTR(char))
 ***		i_name =  strdup(fullname);
 ***};
 ***/
inline
void	EKSObject::dir(char* pathname)
{ i_dir =  pathname? strdup(pathname) : pathname; };

inline
char*	EKSObject::dir()
{ return i_dir; };

inline
void	EKSObject::name(char* instancename)
{ i_name =  strdup(instancename); };

inline
void	EKSObject::name(char* classname, char* instancename)
{
	i_name  = new char[strlen(classname) + strlen(instancename)];
	strcpy(i_name, classname);
	strcat(i_name, instancename);
};

inline
char*	EKSObject::name()
{ return i_name; };

inline
void	EKSObject::directType(Type* t)
{
	initDirectType(t);
};;


#endif
