#include	<string.h>
#include	<stdlib.h>
#include	"infrastructure/EKSObject.h"

Type*	EKSObject_Type_pointer;

Type::Type(char* class_name)
{
	name = strdup(class_name);
};

Type::Type(APL* theAPL)
{};

Type&	Type::operator=(Type& t)
{
	free(name);
	name = strdup(t.name);

	return *this;
};

Boolean	Type::operator==(Type& t)
{
	if (!strcmp(t.name, name))
		return TRUE;
	else
		return FALSE;
};




EKSObject::EKSObject(Metaclass* meta)
{
	i_name = i_dir = NULLPTR(char);
	metaclass = meta;
};

EKSObject::EKSObject(APL* theAPL)
{};

EKSObject::~EKSObject()
{
	Destroy(FALSE);
};

				   /* ARG NOT USED */
void	EKSObject::Destroy(Boolean /*aborted*/)
{
	if (i_name)	free(i_name);
	if (i_dir)	free(i_dir);
};

void	EKSObject::putObject(Boolean deallocate)
{
	if (deallocate) {
		if (i_name)	free(i_name);
		if (i_dir)	free(i_dir);
	};

	cerr << "STORE without oodb!!\n";
	exit(1);
};

void	EKSObject::deleteObject(Boolean deallocate)
{
	if (deallocate) {
		if (i_name)	free(i_name);
		i_name = NULLPTR(char);
		if (i_dir)	free(i_dir);
		i_dir = NULLPTR(char);
	};

	cerr << "FORGET without oodb!!\n";
	exit(1);
};


EKSObject&	EKSObject::operator=(EKSObject& e)
{
	metaclass = e.metaclass;
	dir(e.i_dir);

	return *this;
};


#ifdef DEBUGoid
char*	EKSObject::oid()
{
	char* s = malloc(strlen(i_name)+8);
	strcpy(s, i_name);
	strcat(s, "<");
	strcat(s, l64a((long)this));
	strcat(s, ">");
	return s;
};
# else
char*	EKSObject::oid()
{
	return i_name;
};
#endif

void	EKSObject::initDirectType(Type* t)
{
	i_type = new Type(t->typeName());
};

void	EKSObject::Name(char* fullname)
{
	if (i_name == NULLPTR(char))
		i_name =  strdup(fullname);
};

