#ifndef	EKS_H
#define	EKS_H

#include        <stream.h>
#include        <string.h>
#include        <stdlib.h>

#ifndef DEBUG2
#define DEBUG2 /\
/
#endif
#ifndef DEBUG1
#define DEBUG1 /\
/
#endif
#ifndef DEBUG
#define DEBUG /\
/
#endif

#ifndef NULLPTR
#define         NULLPTR(x)      ((x *)0)
#endif


#ifndef	BOOLEAN_H
enum	OC_Boolean	{ FALSE = 0, TRUE = 1 };
typedef	OC_Boolean	Boolean;
#define	BOOLEAN_H
#endif	BOOLEAN_H

#define	PROTOPATH	"data/prototypes/"


#ifndef TYPE_OF
#define TYPE_OF(class_name)  \
			( class_name/**/_Type_pointer  \
				? class_name/**/_Type_pointer  \
				: class_name/**/_Type_pointer =  \
							new Type("class_name") )
#endif  TYPE_OF


#define	INSTANTIATE(class_name, def) \
			(class_name *)metaclass->make_a("class_name", def)

#define	DELETE(class_name, cls_ptr) \
			metaclass->destroy("class_name", cls_ptr)

#define	STORE(cls_ptr) \
			( cerr << "STORE without oodb!!\n", \
			  exit(1)  )

#define	RETRIEVE(cls_ptr) \
			( cerr << "RETRIEVE without oodb!!\n", \
			  exit(1)  )

#define	FORGET(cls_ptr) \
			( cerr << "FORGET without oodb!!\n", \
			  exit(1)  )



typedef	void	APL;



extern	Boolean	yesno();
#define	YES	yesno()

#define	PI	3.1415927

class	Dimension;
class	Quantity;
class	Mass;
class	Length;
class	Time;
class	Speed;
class	Density;
class	ThermalConductivity;
class	SpecificHeatCapacity;
class	Temperature;
class	Diffusivity;
class	Energy;
class	NonDimensional;
class	Power;
class	Volume;
class	Area;
class	ThermalResistance;
class	Proportion;
class	Viscosity;
class	LuminousIntensity;
////class	Irradiance;
class	Angle;
class	Energy;

#endif
