#ifndef NETWORK_H
#define	NETWORK_H

#include	"infrastructure/list.h"

#ifndef NULLPTR
#define         NULLPTR(x)      ((x *)0)
#endif

//#ifndef	BOOLEAN_H
//enum	OC_Boolean	{ FALSE = 0, TRUE = 1 };
//typedef	OC_Boolean	Boolean;
//#define	BOOLEAN_H
//#endif	BOOLEAN_H

#define sethandler2(generic,atype,btype,x) sethandler(generic,name2(atype,btype),x)
#define errorhandler2(generic,atype,btype)  errorhandler(generic,name2(atype,btype))
#define callerror2(generic,atype,btype,n,s) callerror(generic,name2(atype,btype),n,s)

#define Network(atype,ntype) name3(atype,ntype,PNetwork)
#define NetArc(atype) name2(atype,PNetArc)
#define NetNode(ntype) name2(ntype,PNetNode)
#define	Network_iterator(type) name2(type,PNetwork_iterator)


#define Networkdeclare(atype,ntype)					\
  class	Network(atype,ntype);						\
  class	Network_iterator(ntype);					\
  class	Network_iterator(atype);					\



#define Networkdefine(atype,ntype)					\
  class	NetArc(atype);							\
  class	NetNode(ntype);							\
  typedef	atype*	atype/**/P;					\
  typedef	ntype*	ntype/**/P;					\
									\
template_declare(List,atype);						\
template_declare(List,ntype);						\
									\
  extern GPT errorhandler2(Network,atype,ntype);			\
  extern GPT sethandler2(Network,atype,ntype,GPT);			\
									\
  class	NetArc(atype) : public EKSObject {				\
  protected:								\
	NetNode(ntype)*	source_node;					\
	NetNode(ntype)*	target_node;					\
	atype*		entity;						\
  public:								\
	NetArc(atype)(atype* value, NetNode(ntype)* left,		\
		      		    NetNode(ntype)* right);		\
	NetArc(atype) (APL* theAPL);			/*ONTOS stuff*/ \
	~NetArc(atype) ();						\
									\
	void	Destroy(Boolean aborted);				\
	void	putObject(Boolean deallocate = FALSE);			\
	void	deleteItem(Boolean deallocate);				\
	Type*	getDirectType();					\
									\
	atype*	value();						\
	NetNode(ntype)*	target();					\
	NetNode(ntype)*	source();					\
	NetNode(ntype)*	partner(NetNode(ntype)* n);			\
	Boolean		to(NetNode(ntype)* n);				\
	Boolean		from(NetNode(ntype)* n);			\
	Boolean		involves(NetNode(ntype)* n);			\
  };									\
									\
template_define(List,NetArc(atype));					\
									\
  class NetNode(ntype) : public EKSObject {				\
  protected:								\
	ntype*		entity;						\
	List(NetArc(atype))*	the_arcs;				\
  public:								\
	NetNode(ntype)(ntype* value);					\
	NetNode(ntype)(APL* theAPL);			/*ONTOS stuff*/	\
	~NetNode(ntype) ();						\
									\
	void	Destroy(Boolean aborted);				\
	void	putObject(Boolean deallocate = FALSE);			\
	void	deleteObject(OC_Boolean deallocate);			\
	void	deleteItem(Boolean deallocate);				\
	virtual	Type*	getDirectType();					\
									\
	void		add_arc(NetArc(atype)* an_arc);			\
	ntype*		value();					\
	List(NetArc(atype))*	arcs();					\
	List_iterator(NetArc(atype))&	netarc_iterator();		\
  };									\
									\
template_define(List,NetNode(ntype));					\
									\
  class Network(atype,ntype) : public EKSObject {			\
  protected:								\
  friend	Network_iterator(atype);				\
  friend	Network_iterator(ntype);				\
	List(NetArc(atype))*	the_arcs;				\
	List(NetNode(ntype))*	the_nodes;				\
	Boolean			saved;					\
									\
	NetNode(ntype)*	add_netnode(NetNode(ntype)* a_node);		\
	NetArc(atype)*	add_netarc(NetArc(atype)* an_arc,		\
				NetNode(ntype)* src_node,		\
				NetNode(ntype)* dst_node);		\
	List(NetNode(ntype))*	netnodes();				\
	List(NetArc(atype))*	netarcs();				\
	List_iterator(NetNode(ntype))&	netnode_iterator();		\
	List_iterator(NetArc(atype))&	netarc_iterator();		\
	List_iterator(NetArc(atype))& netarc_iterator(NetNode(ntype)* nn); \
									\
	NetArc(atype)*	netarc(atype* an_arc);				\
	NetNode(ntype)*	netnode(ntype* a_node);				\
  public:								\
	Network(atype,ntype)();						\
	Network(atype,ntype)(APL* theAPL);		/*ONTOS stuff*/	\
	~Network(atype,ntype) ();					\
									\
	void	Destroy (Boolean aborted = FALSE);	/*ONTOS stuff*/	\
	void	putObject(Boolean deallocate);				\
	void	deleteObject(OC_Boolean deallocate);			\
	void	deleteNet(OC_Boolean deallocate);			\
	Type*	getDirectType();					\
									\
	void		add_node(ntype* a_node);			\
	void		add_arc(atype* an_arc, ntype* src_node,		\
					       ntype* dst_node);	\
	int		no_nodes();					\
	int		no_arcs();					\
	Boolean		connected (ntype* n1, ntype* n2);		\
	Boolean		connected (atype* a, ntype* n);			\
	Boolean		arc_source (atype* a, ntype* n);		\
	Boolean		arc_target (atype* a, ntype* n);		\
	atype*		connection (ntype* n1, ntype* n2);		\
	ntype*		connection (atype* a, ntype* n);		\
	ntype*		arc_source (atype* a);				\
	ntype*		arc_target (atype* a);				\
	List(ntype)&	nodes ();					\
	List(atype)&	arcs ();					\
	List(atype)&	connections (ntype* n);				\
	List(ntype)&	neighbours (ntype* n);				\
	Network_iterator(ntype)&	node_iterator();		\
	Network_iterator(atype)&	arc_iterator();			\
	Network_iterator(atype)&	arc_iterator(ntype* n);		\
  };									\
									\
  class	Network_iterator(atype) : private List_iterator(NetArc(atype)) {\
  public:								\
	Network_iterator(atype) (Network(atype,ntype)* network);	\
	Network_iterator(atype) (Network(atype,ntype)* network,ntype* n); \
									\
	atype*	operator() (int direction);				\
	atype*	operator[] (int index);					\
	int	size();							\
  };									\
									\
  class	Network_iterator(ntype) : private List_iterator(NetNode(ntype)){\
  public:								\
	Network_iterator(ntype) (Network(atype,ntype)* network);	\
									\
	ntype*	operator() (int direction);				\
	ntype*	operator[] (int index);					\
	int	size();							\
  }



#define Networkimplement(atype, ntype)					\
  typedef	atype*	atype/**/P;					\
  typedef	ntype*	ntype/**/P;					\
  typedef	void	atype/**/_or_/**/ntype;				\
  class	NetArc(atype);							\
  class	NetNode(ntype);							\
  Type*	NetArc(atype)_Type_pointer;					\
  Type*	NetNode(ntype)_Type_pointer;					\
  Type*	Network(atype,ntype)_Type_pointer;				\
									\
template_define(List,atype/**/_or_/**/ntype);				\
									\
  extern	error(int err_no, char* err_str);			\
  GPT	errorhandler2(Network,atype,ntype) = error;			\
  GPT	sethandler2(Network,atype,ntype, GPT a)				\
  {									\
	GPT oo = errorhandler2(Network,atype,ntype);			\
	errorhandler2(Network,atype,ntype) = a;				\
	return oo;							\
  };									\
									\
  NetArc(atype)::NetArc(atype)(atype* value, NetNode(ntype)* left,	\
					     NetNode(ntype)* right)	\
				: EKSObject(NULLPTR(Metaclass))		\
  {									\
	entity = value;							\
	source_node = left;						\
	target_node = right;						\
  };									\
									\
  NetArc(atype)::NetArc(atype)(APL* theAPL) : EKSObject(theAPL)		\
  {									\
	if (!entity)   return;						\
									\
	RETRIEVE(entity);						\
	if (!entity)							\
		callerror2(Network,atype,ntype, -1,			\
		    "NetArc(atype)::NetArc(atype) - entity not in db");	\
									\
	if(target_node)  RETRIEVE(target_node);/*retrieve all node/arc*/\
	if(source_node)   RETRIEVE(source_node);	    		\
  };									\
									\
  NetArc(atype)::~NetArc(atype)()					\
  {									\
	Destroy(FALSE);							\
  };									\
									\
									\
  void	NetArc(atype)::Destroy(Boolean aborted)				\
  {									\
	/***saved = FALSE;***/			     /* don't delete from db */	\
									\
	/****source_node->delete_arc(*this); ***/				\
	/****target_node->delete_arc(*this); ***/				\
									\
	if (aborted)							\
		EKSObject::Destroy(aborted);				\
  };									\
									\
  void	NetArc(atype)::putObject(Boolean deallocate)			\
				/* NB. only called for head of list */	\
  {									\
	initDirectType(getDirectType());				\
									\
 	STORE(entity);							\
									\
	if(target_node)  STORE(target_node);    /* store all nodes/arc */\
	if(source_node)   STORE(source_node);		    		\
									\
	EKSObject::putObject(deallocate);				\
  };									\
									\
  void	NetArc(atype)::deleteItem(Boolean deallocate)			\
  {									\
 	FORGET(entity);							\
  };									\
									\
  Type*	NetArc(atype)::getDirectType()					\
  {									\
	return TYPE_OF(atype\
PNetArc);								\
  };									\
									\
									\
  atype* NetArc(atype)::value()						\
  {									\
	return entity;							\
  };									\
									\
  NetNode(ntype)*	NetArc(atype)::source()				\
  {									\
	return source_node;						\
  };									\
									\
  NetNode(ntype)*	NetArc(atype)::target()				\
  {									\
									\
	return target_node;						\
  };									\
									\
  NetNode(ntype)* NetArc(atype)::partner(NetNode(ntype)* n)		\
  {									\
	if (n == target_node)						\
		return target_node;					\
	if (n == source_node)						\
		return source_node;					\
									\
	callerror2(Network,atype,ntype, -1,				\
		"NetArc(atype)::target - unknown arc");			\
	return NULLPTR(NetNode(ntype));					\
  };									\
									\
  OC_Boolean	NetArc(atype)::to(NetNode(ntype)* n)			\
  {									\
									\
	return (target_node == n ? TRUE : FALSE);			\
  };									\
									\
  OC_Boolean	NetArc(atype)::from(NetNode(ntype)* n)			\
  {									\
									\
	return (source_node == n ? TRUE : FALSE);			\
  };									\
									\
  OC_Boolean	NetArc(atype)::involves(NetNode(ntype)* n)		\
  {									\
	if (n == source_node  ||  n == target_node)			\
		return TRUE;						\
	return FALSE;							\
  };									\
									\
template_implement(List,NetArc(atype));					\
		/****************************************/		\
									\
  NetNode(ntype)::NetNode(ntype)(ntype* value)				\
					: EKSObject(NULLPTR(Metaclass)) \
  {									\
	the_arcs = new List(NetArc(atype))();				\
	entity = value;							\
  };									\
									\
  NetNode(ntype)::NetNode(ntype)(APL* theAPL) : EKSObject(theAPL)	\
  {									\
	if (!entity)   return;						\
									\
	RETRIEVE(entity);						\
	if (!entity)							\
		callerror2(Network,atype,ntype, -1,			\
		   "NetNode(ntype)::NetNode(ntype) - entity not in db");\
									\
	RETRIEVE(the_arcs);		  /* retrieve all nodes/arcs */ \
  };									\
									\
  NetNode(ntype)::~NetNode(ntype)()					\
  {									\
	Destroy(FALSE);							\
  };									\
									\
									\
  void	NetNode(ntype)::Destroy(Boolean aborted)			\
  {									\
	/***saved = FALSE;***/			     /* don't delete from db */	\
									\
	delete the_arcs;						\
									\
	if (aborted)							\
		EKSObject::Destroy(aborted);				\
  };									\
									\
  void	NetNode(ntype)::putObject(Boolean deallocate)			\
  {									\
	initDirectType(getDirectType());				\
									\
 	STORE(entity);							\
									\
	STORE(the_arcs);		     /* store all nodes/arcs */ \
									\
	EKSObject::putObject(deallocate);				\
  };									\
									\
  void	NetNode(ntype)::deleteObject(Boolean deallocate)		\
  {									\
 	FORGET(entity);							\
									\
	the_arcs->deleteObject(deallocate);	  /* delete all arcs */ \
  };									\
									\
  void	NetNode(ntype)::deleteItem(Boolean deallocate)			\
  {									\
 	FORGET(entity);							\
									\
	the_arcs->deleteList(deallocate);      /* delete arc objects */ \
									\
	deleteObject(deallocate);		  /* zap node & arcs */ \
  };									\
									\
  Type*	NetNode(ntype)::getDirectType()					\
  {									\
	return TYPE_OF(ntype\
PNetNode);								\
  };									\
									\
									\
  ntype*	NetNode(ntype)::value()					\
  {									\
	return entity;							\
  };									\
									\
  List(NetArc(atype))*	NetNode(ntype)::arcs()				\
  {									\
	return the_arcs;						\
  };									\
									\
  List_iterator(NetArc(atype))&	NetNode(ntype)::netarc_iterator()	\
  {									\
	return *new List_iterator(NetArc(atype))(the_arcs);		\
  };									\
									\
  void	NetNode(ntype)::add_arc(NetArc(atype)* an_arc)			\
  {									\
	the_arcs->append(an_arc);					\
  };									\
									\
template_implement(List,NetNode(ntype));				\
		/****************************************/		\
template_implement(List,atype/**/_or_/**/ntype);			\
									\
  Network(atype,ntype)::Network(atype,ntype)()				\
					: EKSObject(NULLPTR(Metaclass)) \
  {									\
	the_arcs = new List(NetArc(atype))();				\
	the_nodes = new List(NetNode(ntype))();				\
	add_node(NULLPTR(ntype));					\
  };									\
									\
  Network(atype,ntype)::Network(atype,ntype)(APL* theAPL)		\
						: EKSObject(theAPL)	\
  {									\
	saved = TRUE;							\
									\
	RETRIEVE(the_arcs);						\
	RETRIEVE(the_nodes);						\
  };									\
									\
  Network(atype,ntype)::~Network(atype,ntype)()				\
  {									\
	Destroy(FALSE);							\
  };									\
									\
									\
  void	Network(atype,ntype)::Destroy(Boolean aborted)			\
  {									\
	saved = FALSE;			     /* don't delete from db */	\
									\
	delete the_arcs;						\
	delete the_nodes;						\
									\
	if (aborted)							\
		EKSObject::Destroy(aborted);				\
  };									\
									\
  void	Network(atype,ntype)::putObject(Boolean deallocate)		\
  {									\
	STORE(the_arcs);						\
	STORE(the_nodes);						\
									\
				    	/* need directType setup */	\
	initDirectType(getDirectType());				\
									\
	saved = TRUE;							\
									\
	EKSObject::putObject(deallocate);	/* save list itself */	\
  };									\
									\
  void	Network(atype,ntype)::deleteObject(OC_Boolean deallocate)	\
  {									\
	if (!saved)							\
	    	return;							\
									\
	saved = FALSE;							\
									\
	FORGET(the_arcs);						\
	FORGET(the_nodes);						\
									\
	EKSObject::deleteObject(deallocate);	/* zap list itself */	\
  };									\
									\
  void	Network(atype,ntype)::deleteNet(OC_Boolean deallocate)		\
  {									\
	if (!saved)							\
	    	return;							\
									\
	saved = FALSE;							\
									\
	the_arcs->deleteList(deallocate);				\
	the_nodes->deleteList(deallocate);				\
									\
	EKSObject::deleteObject(deallocate);				\
  };									\
									\
									\
  Type*	Network(atype,ntype)::getDirectType()				\
  {									\
	return TYPE_OF(atype\
ntype\
PNetwork);								\
  };									\
									\
									\
  NetNode(ntype)* Network(atype,ntype)::add_netnode(NetNode(ntype)* a_netnode) \
  {									\
	the_nodes->append(a_netnode);					\
	return a_netnode;						\
  };									\
									\
  NetArc(atype)*	Network(atype,ntype)::add_netarc(NetArc(atype)* na, \
			NetNode(ntype)* nn1, NetNode(ntype)* nn2)	\
  {									\
	(void)	nn1->add_arc(na);					\
	(void)	nn2->add_arc(na);					\
									\
	the_arcs->append(na);						\
	return na;							\
  };									\
									\
  List(NetNode(ntype))* Network(atype,ntype)::netnodes()		\
  {									\
	return the_nodes;						\
  };									\
									\
  List(NetArc(atype))* Network(atype,ntype)::netarcs()			\
  {									\
	return the_arcs;						\
  };									\
									\
  List_iterator(NetNode(ntype))& Network(atype,ntype)::netnode_iterator()\
  {									\
	List_iterator(NetNode(ntype))* netnode_iter =			\
			new List_iterator(NetNode(ntype))(the_nodes);	\
	return *netnode_iter;						\
  };									\
									\
  List_iterator(NetArc(atype))&	 Network(atype,ntype)::netarc_iterator()\
  {									\
	List_iterator(NetArc(atype))* netarc_iter =			\
			new List_iterator(NetArc(atype))(the_arcs);	\
	return *netarc_iter;						\
  };									\
									\
  List_iterator(NetArc(atype))&   Network(atype,ntype)::netarc_iterator	\
						    (NetNode(ntype)* nn)\
  {									\
	List_iterator(NetArc(atype))* netarc_iter =			\
			new List_iterator(NetArc(atype))(nn->arcs());	\
	return *netarc_iter;						\
  };									\
									\
  NetArc(atype)*	Network(atype,ntype)::netarc(atype* an_arc)	\
  {									\
	List_iterator(NetArc(atype)) netarc_iter(the_arcs);		\
	NetArc(atype)* na;						\
	while (na = netarc_iter(FORWARD)) {				\
		if (na->value() == an_arc)   return na;			\
	};								\
	callerror2(Network,atype,ntype, -1,				\
			"Network(atype,ntype)::arc: unknown arc");	\
	return NULLPTR(NetArc(atype));					\
  };									\
									\
  NetNode(ntype)*	Network(atype,ntype)::netnode(ntype* a_node)	\
  {									\
	List_iterator(NetNode(ntype)) netnode_iter(the_nodes);		\
	NetNode(ntype)* nn;						\
	while (nn = netnode_iter(FORWARD)) {				\
		if (nn->value() == a_node)   return nn;			\
	};								\
	callerror2(Network,atype,ntype, -2,				\
			"Network(atype,ntype)::node: unknown node");	\
	return NULLPTR(NetNode(ntype));					\
  };									\
									\
									\
									\
  void	Network(atype,ntype)::add_node(ntype* a_node)			\
  {									\
	NetNode(ntype)* netnode = new NetNode(ntype)(a_node);		\
	(void) add_netnode(netnode);					\
  };									\
									\
  void	Network(atype,ntype)::add_arc(atype* an_arc, ntype* src_node,	\
						     ntype* dst_node)	\
  {									\
	if (an_arc == NULLPTR(atype)) {					\
		callerror2(Network,atype,ntype, 3,			\
			"Network(atype,ntype)::add_arc: no arc given");	\
		return;							\
	};								\
	NetNode(ntype)*	src_netnode = NULLPTR(NetNode(ntype));		\
	NetNode(ntype)*	dst_netnode = NULLPTR(NetNode(ntype));		\
				/* find both nodes with 1 search */	\
	List_iterator(NetNode(ntype)) netnode_iter(the_nodes);		\
	NetNode(ntype)* nn;						\
	int	found = 0;						\
	while ((nn = netnode_iter(FORWARD))  &&  found != 2) {		\
		if (nn->value() == src_node)  src_netnode = nn, found++;\
		if (nn->value() == dst_node)  dst_netnode = nn, found++;\
	};								\
									\
	if (found != 2)							\
		callerror2(Network,atype,ntype, 4,			\
			"Network(atype,ntype)::add_arc: unknown node");	\
									\
	NetArc(atype)* na = new NetArc(atype)(an_arc, src_netnode,	\
						      dst_netnode);	\
	(void) add_netarc(na, src_netnode, dst_netnode);		\
  };									\
									\
  int	Network(atype,ntype)::no_nodes()				\
  {									\
	return the_nodes->size() - 1;					\
  };									\
									\
  int	Network(atype,ntype)::no_arcs()					\
  {									\
	return the_arcs->size();					\
  };									\
									\
  Boolean	Network(atype,ntype)::connected (ntype* n1, ntype* n2)	\
  {									\
	return ((connection(n1, n2) == NULLPTR(atype))? FALSE: TRUE);	\
  };									\
									\
  Boolean	Network(atype,ntype)::connected (atype* a, ntype* n)	\
  {									\
	return ((connection(a, n) == NULLPTR(ntype))? FALSE: TRUE);	\
  };									\
									\
  Boolean	Network(atype,ntype)::arc_source (atype* a, ntype* n)	\
  {									\
	return ( (arc_source(a) == n)? TRUE:FALSE );			\
  };									\
									\
  Boolean	Network(atype,ntype)::arc_target (atype* a, ntype* n)	\
  {									\
	return ( (arc_target(a) == n)? TRUE:FALSE );			\
  };									\
									\
  atype*	Network(atype,ntype)::connection (ntype* n1, ntype* n2)	\
  {									\
				/* find either node with 1 search */	\
	ntype*	other_node = NULLPTR(ntype);				\
	List_iterator(NetNode(ntype)) netnode_iter(the_nodes);		\
	NetNode(ntype)* nn;						\
	while (nn = netnode_iter(FORWARD)) {				\
		if (nn->value() == n1)					\
			other_node = n2;				\
		else if (nn->value() == n2)				\
			other_node = n1;				\
		else	continue;					\
		List_iterator(NetArc(atype))& netarc_iter =		\
						nn->netarc_iterator();	\
		NetArc(atype)* na;					\
		while (na = netarc_iter(FORWARD)) {			\
			if (na->source()->value() == other_node   ||	\
		  	    na->target()->value() == other_node)	\
			return na->value();				\
		};							\
		return NULLPTR(atype);					\
	};								\
	callerror2(Network,atype,ntype, -5,				\
		      "Network(atype,ntype)::connection: unknown node");\
	return NULLPTR(atype);						\
  };									\
									\
  ntype*	Network(atype,ntype)::connection (atype* a, ntype* n)	\
  {									\
	NetNode(ntype)* nn = netnode(n);				\
									\
	if (nn == NULLPTR(NetNode(ntype)))   return NULLPTR(ntype);	\
									\
	List_iterator(NetArc(atype))& netarc_iter=nn->netarc_iterator();\
	NetArc(atype)* na;						\
	while (na = netarc_iter(FORWARD)) {				\
		if (na->value() == a)					\
			if (na->source()->value() == n)			\
				return na->target()->value();		\
			else return na->source()->value();		\
	};								\
	callerror2(Network,atype,ntype, -6,				\
		      "Network (atype,ntype)::connection: unknown arc");\
	return NULLPTR(ntype);						\
  };									\
									\
  ntype*	Network(atype,ntype)::arc_source (atype* a)		\
  {									\
	return netarc(a)->source()->value();				\
  };									\
									\
  ntype*	Network(atype,ntype)::arc_target (atype* a)		\
  {									\
	return netarc(a)->target()->value();				\
  };									\
									\
  List(ntype)&	Network(atype,ntype)::nodes ()				\
  {					/* skip "outside" node */	\
	List(atype/**/_or_/**/ntype)* node_lst =			\
					new List(atype/**/_or_/**/ntype);\
									\
	List_iterator(NetNode(ntype))& netnode_iter =netnode_iterator();\
	NetNode(ntype)*	nn;						\
	(void) netnode_iter(FORWARD);					\
	while (nn = netnode_iter(FORWARD))				\
		node_lst->append(nn->value());				\
									\
	return *(List(ntype)*)node_lst;					\
  };									\
									\
  List(atype)&	Network(atype,ntype)::arcs ()				\
  {									\
	List(atype/**/_or_/**/ntype)* arc_lst =				\
					new List(atype/**/_or_/**/ntype);\
									\
	List_iterator(NetArc(atype))& netarc_iter =netarc_iterator();	\
	NetArc(atype)*	na;						\
	while (na = netarc_iter(FORWARD))				\
		arc_lst->append(na->value());				\
									\
	return *(List(atype)*)arc_lst;					\
  };									\
									\
  List(atype)&	Network(atype,ntype)::connections (ntype* n)		\
  {									\
	List(atype/**/_or_/**/ntype)* arc_lst =				\
					new List(atype/**/_or_/**/ntype);\
	NetNode(ntype)* nn = netnode(n);				\
									\
	if (nn == NULLPTR(NetNode(ntype))) return *(List(atype)*)arc_lst; \
									\
	List_iterator(NetArc(atype))& netarc_iter = nn->netarc_iterator(); \
	NetArc(atype)*	na;						\
	while (na = netarc_iter(FORWARD))				\
		arc_lst->append(na->value());				\
									\
	return *(List(atype)*)arc_lst;					\
  };									\
									\
  List(ntype)&	Network(atype,ntype)::neighbours (ntype* n)		\
  {					/* skip "outside" node */	\
	List(atype/**/_or_/**/ntype)* node_lst =			\
					new List(atype/**/_or_/**/ntype);\
	NetNode(ntype)* nn = netnode(n);				\
									\
	if (nn == NULLPTR(NetNode(ntype))) return *(List(ntype)*)node_lst; \
									\
	List_iterator(NetArc(atype))& netarc_iter = nn->netarc_iterator(); \
	NetArc(atype)*	na;						\
	while (na = netarc_iter(FORWARD))				\
		if ((na->source()->value() == n) && na->target()->value()) \
			node_lst->append(na->target()->value());	\
		else if (na->source()->value())				\
			 node_lst->append(na->source()->value());	\
									\
	return *(List(ntype)*)node_lst;					\
  };									\
									\
  Network_iterator(ntype)&	Network(atype,ntype)::node_iterator()	\
  {									\
	Network_iterator(ntype)* x = new Network_iterator(ntype)(this);	\
	return *x;							\
  };									\
									\
  Network_iterator(atype)&	Network(atype,ntype)::arc_iterator()	\
  {									\
	return *new Network_iterator(atype)(this);			\
  };									\
									\
  Network_iterator(atype)&	Network(atype,ntype)::arc_iterator(	\
							       ntype* n)\
  {									\
	return *new Network_iterator(atype)(this, n);			\
  };									\
									\
		/****************************************/		\
									\
  Network_iterator(atype)::Network_iterator(atype)			\
					(Network(atype,ntype)* network)	\
			: (network->netarcs())				\
  {};									\
									\
  Network_iterator(atype)::Network_iterator(atype)			\
			(Network(atype,ntype)* network, ntype* n)	\
			: (network->netnode(n)->arcs())			\
  {};									\
									\
  atype*	Network_iterator(atype)::operator()(int direction)	\
  {									\
	NetArc(atype)* netarc = List_iterator(NetArc(atype))::operator()( \
							direction);	\
	return (netarc != NULLPTR(NetArc(atype))? netarc->value()	\
					        : NULLPTR(atype));	\
  };									\
									\
  atype*	Network_iterator(atype)::operator[](int index)		\
  {									\
	NetArc(atype)* netarc = List_iterator(NetArc(atype))::operator[]( \
								index);	\
	return (netarc != NULLPTR(NetArc(atype))? netarc->value()	\
					        : NULLPTR(atype));	\
  };									\
									\
  int	Network_iterator(atype)::size()					\
  {									\
	return List_iterator(NetArc(atype))::size();			\
  };									\
									\
									\
  Network_iterator(ntype)::Network_iterator(ntype)			\
					(Network(atype,ntype)* network)	\
			: (network->netnodes())				\
  {									\
  };									\
									\
  ntype*	Network_iterator(ntype)::operator()(int direction)	\
  {					/* skip "outside" node */	\
	NetNode(ntype)* netnode=List_iterator(NetNode(ntype))::operator()( \
							     direction);\
	if (netnode == NULLPTR(NetNode(ntype)))				\
		return NULLPTR(ntype);					\
	if (netnode->value() == NULLPTR(ntype))				\
		return operator()(direction);				\
  };									\
									\
  ntype*	Network_iterator(ntype)::operator[](int index)		\
  {					/* skip "outside" node */	\
	NetNode(ntype)* netnode=List_iterator(NetNode(ntype))::operator[]( \
								 index+1); \
	return (netnode != NULLPTR(NetNode(ntype))? netnode->value()	\
						  : NULLPTR(ntype));	\
  };									\
									\
  int	Network_iterator(ntype)::size()					\
  {					/* skip "outside" node */	\
	return List_iterator(NetNode(ntype))::size() - 1;		\
  };

#endif
