#include	"infrastructure/Template.h"

#include	<sys/types.h>
#include	<sys/stat.h>
#include	"infrastructure/Metaclass.h"
#include	"context/Context.h"
#include	"context/Context_def.h"

Type*	Template_Type_pointer;
extern	Metaclass*	make_meta_for(char* classname, Template* tp);


char*	eat_white(char* buffer)
{
	while (isspace(*buffer))   buffer++;
	char* cp = buffer;
	while (isgraph(*cp))   cp++;
	*cp = '\0';
	return buffer;
};

					 /* Retrieve the metaproto from the
					 * appropriate directory
					 */
Metaproto*	Template::get_proto(char* class_name)
{
	char	protopath[128];
	strcpy(protopath, PROTOPATH);
////	strcat(protopath, ">");
	strcat(protopath, class_name);
	Metaproto*	mp = (Metaproto*)OC_lookup(protopath);
	return mp;
};



				// ctor to define new template
Template::Template() : EKSObject(NULLPTR(Metaclass))
{
	DEBUG	<< "Template::Template()\n";

	initDirectType(TYPE_OF(Template));
	m_cls_list = new List(Metaclass);

	cout << "For each of the following EKS classes, please give\n"
	     << "the name of the actual class to be used by the program\n\n";

	setup("Context");		// define required context & recursively
					//	all aux classes it needs

	char t_name[64];
	cout << "What do you want to call this template?\n";
	cin >> t_name;
	name(t_name);
						// make a directory for template
	char	templatepath[128];
	strcpy(templatepath, "^");			// EKS base directory
	strcat(templatepath, t_name);
	Directory*	template_directory = (Directory*)OC_lookup(templatepath);

	if (template_directory) {
		Template*	tp;
		if (tp = (Template*)template_directory->getObject(t_name)) {
			cout << "Overwrite existing version of this Template? ";
			if ( !YES )   exit(1);
		};
		tp->deleteObject(TRUE);
	} else {
		template_directory = new Directory(templatepath);
		template_directory->putObject(FALSE);
	};
						// . . . and put Template in it
	strcat(templatepath, ">");
	dir(templatepath);
	strcat(templatepath, name());
	Name(templatepath);
	putObject(FALSE);
};

Template::Template(APL* theAPL) : EKSObject(theAPL)
{
	DEBUG	<< "Template::Template(APL* theAPL)\n";

	RETRIEVE(m_cls_list);
};

				// 'notional' is the name the EKS variant that
				//	provides all the necessary functionality
void	Template::setup(char* notional)
{
	DEBUG1	<< "Template::setup(" << notional << ")\n";

	Type*	n_type = (Type*)OC_lookup(notional);

	Metaproto*	m_proto;
	char	actual[64];
	do {
		cout << notional << "? ";
		cin >> actual;
		m_proto = get_proto(actual);
	} while ((!m_proto && cout << "\tSorry, but thats not a EKS class!\n")  ||
		 (!m_proto->protege_type->AKO(n_type)  &&
		 	cout << "\tSorry, but thats not derived from " << notional <<"!\n"));

	Metaclass*	m_cls = new Metaclass(actual, notional, this);
	m_cls_list->append(m_cls);

	char** aux_cls = m_cls->auxiliary_classes();
	while (*aux_cls != NULLPTR(char))
		setup(*aux_cls++);

	delete m_proto;
};

Metaclass* Template::get_meta_for(char* eksname)
{
	DEBUG1	<< "Template::get_meta_for(" << eksname << ")\n";

	Type*	n_type = (Type*)OC_lookup(eksname);

	List_iterator(Metaclass)	m_iter(m_cls_list);
	Metaclass*	m;
	while (m = m_iter(FORWARD))
		if (m->protege_type->AKO(n_type))
			return m;

	cerr << "template: can't get meta for " << eksname << "\n";
	return NULLPTR(Metaclass);
////	delete n_type;			//// need to delete 
};

void	Template::dump(char* filename)
{
	DEBUG1	<< "Template::dump(" << filename << ")\n";

	FILE* file = fopen(filename, "w+");

	List_iterator(Metaclass)	m_iter(m_cls_list);
	Metaclass*	m;
	while (m = m_iter(FORWARD))
		fprintf(file, "%20s : %30s : %30s\n", m->protege_base_name,
						      m->name(),
						      m->protege_class_name);
	fclose(file);
};

Template::Template(char* template_name) : EKSObject(NULLPTR(Metaclass))
{
	DEBUG	<< "Template::Template(" << filename << ")\n";

	char	templatepath[128];
	strcpy(templatepath, "^");			// EKS base directory
	strcat(templatepath, template_name);
	Directory*	template_directory = (Directory*)OC_lookup(templatepath);
	Template*	tp;
	if (template_directory)
		tp = (Template*)template_directory->getObject(template_name);
	if (!template_directory  ||  !tp) {
		DEBUG2 << "no stored Template, looking for template file\n";
		load(template_name);
	} else {
		m_cls_list = tp->m_cls_list;
		name(tp->name());
		dir(tp->dir());
	};
};


void	Template::load(char* filename)
{
	DEBUG1	<< "Template::load(" << filename << ")\n";

	FILE*	file = fopen(filename, "r");

	m_cls_list = new List(Metaclass);

	char	templatepath[128];
	strcpy(templatepath, filename);			// get directory
	char*	n = strrchr(templatepath, '/');
	if (n) {
		*n++ = '\0';
	} else {
		n = filename;
		cout << "What directory is Template " << filename << " in? ";
		cin >> templatepath;
		strcat(templatepath, "/");
	};
	name(n);
	dir(templatepath);
	strcat(templatepath, n);

	struct stat	stat_buf;
	if (stat(templatepath, &stat_buf)) {
		cout << "No such Template / directory!!\n\n";
		exit(1);
	};


	char	base[64];
	char	notional[64];
	char	actual[64];
	while (fscanf(file, "%s : %s : %s ", base, notional, actual) == 3) {
		Metaproto* m_proto = get_proto(actual);
		if (strcmp(m_proto->protege_base_name, base)) {
			cerr << "Template:Template(char*) : " << actual
			     << " is not a " << base << "\n";
			exit(1);
		};
		Metaclass*	m_cls = new Metaclass(actual, notional, this);
		m_cls_list->append(m_cls);
		delete m_proto;
	};
};

Template::~Template()
{
	DEBUG << "Template::~Template()\n";

	Destroy(FALSE);
};


void	Template::Destroy(Boolean aborted)
{
	DEBUG << "Template::Destroy(Boolean aborted)\n";

	if (aborted)
		EKSObject::Destroy(aborted);
};


void	Template::desc_data(ostream& s)
{
	DEBUG1	<< "Template::build_data()\n";

	s << "Template " << name() << ":\n\n";

	Metaclass* m_ctx = get_meta_for("Context");

	m_ctx->desc_X_def(s);
};

Context_def*	Template::build_data()
{
	DEBUG1	<< "Template::build_data()\n";

	Metaclass* m_ctx = get_meta_for("Context");
	return (Context_def*)(m_ctx->make_X_def());
};


void	Template::save_data(char* dataset_name)
{
	DEBUG1	<< "Template::save_data(char* dataset_name)\n";

	char	d_name[128];
	strcpy(d_name, dataset_name);

	char	dataset_path[128];
	strcpy(dataset_path, dir());
	strcat(dataset_path, d_name);

	Directory*	dataset_dir;
	do {
		strcpy(dataset_path, dir());
		strcat(dataset_path, d_name);
		dataset_dir = (Directory*)OC_lookup(dataset_path);
	} while ( dataset_dir  && 
		  cout << "Existing dataset with this name!  "
		     << "Please specify an alternative name > "  &&
		  cin >> d_name );
	dataset_dir = new Directory(dataset_path);
	dataset_dir->putObject(FALSE);

	strcat(dataset_path, ">");
	List_iterator(Metaclass)	m_iter(m_cls_list);
	Metaclass*	m;
	while (m = m_iter(FORWARD))
		m->save_defs(dataset_path);

	delete dataset_dir;
};



Context*	Template::build_prog(Context_def* x_def)
{
	DEBUG1	<< "Template::build_prog()\n";

	Metaclass* m_ctx = get_meta_for("Context");
	return (Context*)(m_ctx->instantiate(m_ctx, x_def));
};


void	Template::putObject(Boolean deallocate)
{
	DEBUG1	<< "Template::putObject(Boolean deallocate)\n";

	char	buffer[128];
	strcpy(buffer, dir());
	m_cls_list->dir(buffer);
	strcat(buffer, name());
	strcat(buffer, ".Mlist");
	m_cls_list->name(name(), ".Mlist");
	m_cls_list->Name(buffer);
	m_cls_list->putObject(FALSE);		// save associated Metaclasses

	EKSObject::putObject(deallocate);
};



template_implement(List,Metaclass);
