#include "Metaproto.h"

#include	<string.h>
#include	<stdlib.h>
#include	<ONTOS/Object.h>
#include	<ONTOS/ArgumentList.h>
#include	<ONTOS/Procedure.h>
#include	"context/X_def.h"

Type*	Metaproto_Type_pointer;


					/* this protected ctor is used by Metaclass
					 * to ctor its base class to the data
					 * saved in the ONTOS metaproto directory
					 */
Metaproto::Metaproto(Metaproto& mp)	: EKSObject(NULLPTR(Metaclass))
{
	DEBUG	<< "Metaproto::Metaproto(Metaproto& mp))\n";

	dir(mp.dir());
	name(mp.protege_class_name);

	protege_class_name = strdup(mp.protege_class_name);
	protege_type = mp.protege_type;
	protege_base_name = strdup(mp.protege_base_name);
	x_def_class_name = strdup(mp.x_def_class_name);
	x_def_type = mp.x_def_type;
	callers = new List(char)(*mp.callers);
	auxiliaries = new List(char)(*mp.auxiliaries);
};


				/* Make a prototype Metaclass
				 */
Metaproto::Metaproto(char* class_name)  : EKSObject(NULLPTR(Metaclass))
{
	DEBUG	<< "Metaproto::Metaproto(" << class_name << ")\n";

					// check class exists in ONTOS & is ok
	protege_type = (Type*)OC_lookup(class_name);
	if ( protege_type == NULLPTR(Type)  ||
	     protege_type->AKO(TYPE_OF(EKSObject)) == FALSE ) {
		cerr << "\tSorry, don't recognise class "<< class_name << "!\n"
		     << "\t\t(NB. You have classified it?)\n";
		return;
	};

					// want to place retain appropriate ONTOS
					// directory so templates can find it
	char	protopath[128];
	strcpy(protopath, PROTOPATH);
	dir(protopath);
////	strcat(protopath, ">");
	strcat(protopath, class_name);
					// handle name conflicts
	Metaproto* m = (Metaproto*)OC_lookup(protopath);
	if (m) {
		cout << "Overwrite existing version of this Metaclass prototype? ";
		if ( !YES )   exit(1); 
		m->deleteObject(TRUE);
	};
	protege_class_name = strdup(class_name);

	name(class_name);
	Name(protopath);			// set name to full pathname

						// now get name of EKS base class
	static	char	buff[128];
	while(1) {
		cout << "EKS class for which " << class_name
		     << " is a variant >";
		cin >> buff;

		Type*	base_type;
		if ((base_type = (Type*)OC_lookup(buff)) != NULLPTR(Type)  &&
		    !protege_type->AKO(base_type) )
			cout << "\tSorry, don't recognise that class!\n"
			     << "\t\t(NB. It was classified?)\n";
		else
			break;
	};
	protege_base_name = strdup(buff);

						// now get name of reqd X-def class
	while(1) {
		cout << "What x-def class is used by " << class_name << " >";
		cin >> buff;

		if ((x_def_type = (Type*)OC_lookup(buff)) == NULLPTR(Type)  ||
		     !x_def_type->AKO(TYPE_OF(X_def)) )
			cout <<"\tSorry, don't recognise that class as an X-def!\n"
			     << "\t\t(NB. You have classified it?)\n";
		else
			break;
	};
	x_def_class_name = strdup(buff);

					// now capture usage info
	callers = new List(char);
	cout << "If " << class_name << " calls member functions in the class\n"
	     << "which invokes it, give a list of acceptable callers\n"
	     <<  "otherwise (ie a null list) any caller is deemed acceptable\n"
	     << "\t\t(terminate list with '.')\n\t> ";
	char	a_caller_typename[128];
	cin >> a_caller_typename;
	while (strlen(a_caller_typename) != 0  &&  *a_caller_typename != '.') {
		strcpy(protopath, dir());
		strcat(protopath, ">");
		strcat(protopath, a_caller_typename);
		if ((Metaproto*)OC_lookup(protopath) == NULLPTR(Metaproto))
			cout << "\tSorry, don't recognise that as an EKSclass!\n"
			     <<"\t\t(ie, no prototype metaclass defined for it)\n";
		else
			callers->append(strdup(a_caller_typename));
		cout << "\t> ";
		cin >> a_caller_typename;
	};

	auxiliaries = new List(char);
	cout << "If " << class_name << " invokes (instantiates) other classes\n"
	     << "to support it, give a list of those classes\n"
	     << "\t\t(terminate list with '.')\n\t> ";
	char	a_aux_typename[128];
	cin >> a_aux_typename;
	while (strlen(a_aux_typename) != 0  &&  *a_aux_typename != '.') {
		strcpy(protopath, dir());
		strcat(protopath, ">");
		strcat(protopath, a_aux_typename);
		if ((Metaproto*)OC_lookup(protopath) == NULLPTR(Metaproto))
			cout << "\tWarning, no prototype exists for this yet!\n";
		char*	str = strdup(a_aux_typename);
		auxiliaries->append(str);
		cout << "\t> ";
		cin >> a_aux_typename;
	};
					// save object in ONTOS
	initDirectType(getDirectType());
	putObject(FALSE);			// automatically saved!
};	

Metaproto::Metaproto(char* class_name, char* base_name, char* x_def_name,
					char** caller_types, char** aux_classes)
					: EKSObject(NULLPTR(Metaclass))
{
	DEBUG	<< "Metaproto::Metaproto(" << class_name << ")\n";

					// check class exists in ONTOS & is ok
	protege_type = (Type*)OC_lookup(class_name);
	if ( protege_type == NULLPTR(Type)  ||
	     protege_type->AKO(TYPE_OF(EKSObject)) == FALSE ) {
		cerr << "\tSorry, don't recognise class "<< class_name << "!\n"
		     << "\t\t(NB. You have classified it?)\n";
		return;
	};

					// want to place retain appropriate ONTOS
					// directory so templates can find it
	char	protopath[128];
	strcpy(protopath, PROTOPATH);
	dir(protopath);
////	strcat(protopath, ">");
	strcat(protopath, class_name);
					// handle name conflicts
	Metaproto* m = (Metaproto*)OC_lookup(protopath);
	if (m) {
		cout << "Overwrite existing version of Metaclass prototype for "
		     << class_name << " ? ";
		if ( !YES )   exit(1); 
		m->deleteObject(TRUE);
	};
	protege_class_name = strdup(class_name);

	name(class_name);
	Name(protopath);			// set name to full pathname

						// now get name of EKS base class
	Type*	base_type;
	if ((base_type = (Type*)OC_lookup(base_name)) != NULLPTR(Type)  &&
	    !protege_type->AKO(base_type) ) {
		cout << "\tSorry, don't recognise class " << base_name
		     << "!\n\t\t(NB. It was classified?)\n";
		exit(1);
	};
	protege_base_name = strdup(base_name);

						// now get name of X-def class
	x_def_type = (Type*)OC_lookup(x_def_name);
	if ( x_def_type == NULLPTR(Type)  ||
	     x_def_type->AKO(TYPE_OF(X_def)) == FALSE ) {
		cerr << "\tSorry, don't recognise class "<< x_def_name << "!\n"
		     << "\t\t(NB. You have classified it?)\n";
		return;
	};
	x_def_class_name = strdup(x_def_name);

					// now capture usage info
	callers = new List(char);
	int c;
	for (c=0; caller_types[c] != NULLPTR(char); c++) {
		strcpy(protopath, dir());
		strcat(protopath, ">");
		strcat(protopath, caller_types[c]);
		if ((Metaproto*)OC_lookup(protopath) == NULLPTR(Metaproto)) {
			cout << "\tSorry, don't recognise that as an EKSclass!\n"
			     <<"\t\t(ie, no prototype metaclass defined for it)\n";
			exit(1);
		};
		callers->append(strdup(caller_types[c]));
	};


	auxiliaries = new List(char);
	for (c=0; aux_classes[c] != NULLPTR(char); c++) {
		strcpy(protopath, dir());
		strcat(protopath, ">");
		strcat(protopath, aux_classes[c]);
		if ((Metaproto*)OC_lookup(protopath) == NULLPTR(Metaproto)) {
			cout << "\tWarning, no prototype exists for this yet!\n";
			exit(1);
		};
		auxiliaries->append(aux_classes[c]);
	};
					// save object in ONTOS
	initDirectType(getDirectType());
	putObject(FALSE);			// automatically saved!
};	

Metaproto::Metaproto(APL* theAPL) : EKSObject(theAPL)
{
	DEBUG << "Metaproto::Metaproto(APL* theAPL)\n";

	RETRIEVE(callers);
	RETRIEVE(auxiliaries);
	protege_type = (Type*)OC_lookup(protege_class_name);
	x_def_type = (Type*)OC_lookup(x_def_class_name);
};

Metaproto::~Metaproto()
{
	DEBUG << "Metaproto::~Metaproto()\n";

	Destroy(FALSE);
};

void	Metaproto::Destroy(Boolean aborted)
{
	DEBUG << "Metaproto::Destroy(Boolean aborted)\n";

	delete protege_class_name;
	delete protege_base_name;
	delete x_def_class_name;

	delete callers;
	delete auxiliaries;
	callers = auxiliaries = NULLPTR(List(char));
	
	if(aborted)
		EKSObject::Destroy(aborted);
};


void	Metaproto::putObject(Boolean deallocate)
{
	DEBUG << "Metaproto::putObject(Boolean deallocate)\n";

	STORE(callers);
	STORE(auxiliaries);

	EKSObject::putObject(deallocate);
};

void	Metaproto::deleteObject(Boolean deallocate)
{
	DEBUG << "Metaproto::putObject(Boolean deallocate)\n";

	FORGET(callers);
	FORGET(auxiliaries);

	EKSObject::deleteObject(deallocate);
};


Boolean Metaproto::check_ok_for(Metaproto* the_caller)
{
	DEBUG1	<< "Boolean Metaproto::check_ok_for(Metaproto* caller)\n";
				// check caller has everything this needs
	if (callers->size() == 0)
		return TRUE;			// no restrictions

	List_iterator(char)	clr_iter(callers);
	char*	clr;
	while (clr = clr_iter(FORWARD))
		if (!strcmp(the_caller->protege_type->typeName(), clr))
			return TRUE;
	return FALSE;
};


char**	Metaproto::auxiliary_classes()
{
	DEBUG1	<< "Metaproto::auxiliary_classes()\n";

						// from reqd functions, get list
						//	of aux classes to ask for
	int	sz = auxiliaries->size();

	char**	aux_fns_classes = (char**)malloc((sz+1) * sizeof(char*));
	aux_fns_classes[sz] = NULLPTR(char);

	if (sz == 0)
		return aux_fns_classes;

	List_iterator(char)	aux_iter(auxiliaries);
	char*	str;
	int	i = 0;
	while (str = aux_iter(FORWARD))
		aux_fns_classes[i++] = strdup(str);
	return aux_fns_classes;
};



template_implement(List,char);
