#ifndef META_X_H
#define META_X_H

#include	"infrastructure/Metaproto.h"
#include	"context/X_def.h"
class	Template;
class	EKSObject;
#include	"infrastructure/list.h"
template_define(List,EKSObject);
template_define(List,X_def);


extern Type*	Metaclass_Type_pointer;

class  Metaclass : public Metaproto {
protected:
friend	Template;
	Template*		the_template;
	List(EKSObject)*	protege_instances;	// NB do not give ANYONE
	List(X_def)*		x_def_instances;	// copies of these ptrs
	Boolean			saved_state;
	Boolean			saved_data;

	virtual	EKSObject*	link_to(char* classname);
	virtual	EKSObject*	instantiate(Metaclass* caller, X_def* x_def);
	virtual	void		destroy(Metaclass* caller, EKSObject* obj);
	virtual	void		desc_X_def(ostream& s);
	virtual	X_def*		make_X_def();
	virtual	void		save_state(char* savedstate_name);
	virtual	void		save_defs(char* dataset_name);

					// NB only accessible via Template
	Metaclass(char* class_name, char* notional, Template* tp);
	Metaclass(APL*	theAPL);
	~Metaclass();
	void	Destroy(Boolean aborted);
	void	putObject(Boolean deallocate);
	void	deleteObject(Boolean deallocate);
public:
	Type*	getDirectType();
		/* the folowing are used by my instances to access other classes
		 * NB check real type of object returned and cast appropriately
		*/
	virtual	EKSObject*	link_to(char* classname, char* instance_name);
	virtual	EKSObject*	make_a(char* classname, X_def* x_def);
	virtual	void		destroy(char* classname, EKSObject* obj);
	virtual	void		describe_def_for(char* classname, ostream& s);
	virtual	X_def*		make_def_for(char* classname);
};	


inline
Type*	Metaclass::getDirectType()
{
	return TYPE_OF(Metaclass);
};

#endif
