#ifndef	EKSOBJECT_H
#define	EKSOBJECT_H

#ifdef DEBUG
#define DEBUGoid
#endif

#include	<ONTOS/Database.h>
#include	<ONTOS/Directory.h>
#include	<ONTOS/Type.h>
#include	<ONTOS/Object.h>
#include	<ONTOS/Primitives.h>

#include	"infrastructure/EKS.h"


class	Metaclass;

extern Type*	EKSObject_Type_pointer;

class EKSObject : public Object {
protected:
	char*			i_dir;
	char*			i_name;
	Metaclass*		metaclass;

	EKSObject(Metaclass* meta);
	EKSObject(APL* theAPL);
virtual	~EKSObject();

	EKSObject&	operator=(EKSObject& s);

	void		Destroy(Boolean aborted);
	void		putObject(Boolean deallocate);
	void		dir(char* pathname);
	void		name(char* instancename);
	void		name(char* classname, char* instancename);
public:
	char*		dir();
	char*		name();
virtual	char*		oid();

};


inline
void	EKSObject::putObject(Boolean deallocate)
{ Object::putObject(deallocate); };

inline
void	EKSObject::dir(char* pathname)
{ i_dir =  pathname? strdup(pathname) : pathname; };

inline
char*	EKSObject::dir()
{ return i_dir; };

inline
void	EKSObject::name(char* instancename)
{ i_name =  strdup(instancename); };

inline
void	EKSObject::name(char* classname, char* instancename)
{
	i_name  = new char[strlen(classname) + strlen(instancename)];
	strcpy(i_name, classname);
	strcat(i_name, instancename);
};

inline
char*	EKSObject::name()
{ return i_name; };

#endif
