#include	<stream.h>
#include	<string.h>
#include	<osfcn.h>
#include	<stdlib.h>
#include        <ONTOS/Database.h>
#include        <ONTOS/Object.h>
#include	"infrastructure/EKS.h"

			/* used by STORE macro expansion in EKS.h */
void	::putObject(char* str, Boolean deallocate)
{
	if (deallocate)   free(str);	// stored in db automatically
};
void	::putObject(Object* obj, Boolean deallocate)
{
	obj->putObject(deallocate);
};
void	::putObject(void* inst, Boolean deallocate)
{
	cerr << "Ignoring attempt to store non persistent object in db\n";
};

			/* used by RETRIEVE macro expansion in EKS.h */
void	::getObject(char* str)
{
};
void	::getObject(Object* obj)
{
};
void	::getObject(void* inst)
{
	cerr << "Ignoring attempt to retrieve non persistent object from db\n";
};


			/* used by FORGET macro expansion in EKS.h */
void	::deleteObject(char* str, Boolean deallocate)
{
	if (deallocate)   free(str);
};
void	::deleteObject(Object* obj, Boolean deallocate)
{
	obj->deleteObject(deallocate);
};
void	::deleteObject(void* inst, Boolean deallocate)
{
	cerr << "Ignoring attempt to delete non persistent object from db\n";;
};


				/* utility fns */
Boolean	yesno()
{
	char	ans[4];

	cin >> ans;
	if (*ans == 'y')   return TRUE;
	else   return FALSE;
};

			/* ONTOS startup */
void	EKSinit()
{
	OC_open("EKStst");
	OC_transactionStart();
}

void	EKSquit()
{
	cerr << "Commit? ";
	if (YES)
		OC_transactionCommit();
	else
		OC_transactionAbort();

	OC_close();
};


				/* generic error handling, for template_implement*/
void	warning_serious(int err_no, char* s)
{
	if (err_no > 0)
		cerr << s << "\n";
};
void	warning(int /*err_no*/, char* s)			// ARG_NOT_USED
{
	cerr << s << "\n";
};
void	error_serious(int err_no, char* s)
{
	if (err_no < 0)
		return;
	cerr << s << "\n";
	exit(1);
};
void	error(int err_no, char* s)
{
	cerr << s << "\n";
	if (err_no < 0)
		return;
	exit(1);
};
void	error_fatal(int /*err_no*/, char* s)			// ARG_NOT_USED
{
	cerr << s << "\n";
	exit(1);
};
