#ifndef CONVECTION_H
#define CONVECTION_H

#include	"infrastructure/EKSObject.h"
class	Convection_def;
class	AirVolume_es;
class	State_variable;
class	State_vector;
class	Equation_set;
class	Equation_iterator;

extern	Type*	Convection_Type_pointer;

/*
** Base class for the calculation of convection.
*/


class Convection : public EKSObject {
protected:
	Convection(Metaclass* meta, Convection_def* def);
	Convection(Convection& c);
	Convection(APL* theAPL);
	~Convection();
public:
	Type*	getDirectType();

virtual Equation_set	generate_equations(State_vector* state_vector,
					   EKSObject*  airvol,
					   Equation_iterator  airvol_eqn_iter) = 0;
virtual	Equation_set	combine_equations(Equation_iterator  airvol1_eqn_iter,
					  State_variable*  airvol1_air_node,
					  Equation_iterator  airvol2_eqn_iter,
					  State_variable*  airvol2_air_node,
					  EKSObject*  data_supplier) = 0;
virtual	void		add_coupling(Equation_iterator  airvol1_eqn_iter,
				     State_variable*  node_in_airvol1,
				     Equation_iterator  region2_eqn_iter,
				     State_variable*  node_in_region2,
				     EKSObject*  data_supplier) = 0;
virtual	void		inject_energy(Equation_iterator  airvol_eqn_iter,
				      State_variable*  node_in_airvol,
				      Energy  gain) = 0;
};


inline
Type*	Convection::getDirectType()
{
	return TYPE_OF(Convection);
};
#endif
