#include	"theory/Context_domain_ccrs_def.h"

#include	"infrastructure/Metaclass.h"
#include	"theory/Shortwave_def.h"	// for debug oid()


Context_domain_ccrs_def::Context_domain_ccrs_def(Metaclass* meta)
						: Context_domain_ccr_def(meta)
{
	DEBUG	<< "Context_domain_ccrs_def::Context_domain_ccrs_def(" << meta->oid() << ")\n";

	shortwave = (Shortwave_def*)meta->make_def_for("Shortwave");
};

Context_domain_ccrs_def::Context_domain_ccrs_def(Conduction_def* a_conduct_def,
				       Convection_def* a_convect_def,
				       Radiation_def* a_rad_def,
				       Shortwave_def* a_sw_def,
				       Solver_def* a_solver_def)
		: Context_domain_ccr_def(a_conduct_def, a_convect_def,
				         a_rad_def, a_solver_def)
{
	DEBUG	<< "Context_domain_ccrs_def::Context_domain_ccrs_def(Conduction_def* a_conduct_def . . . , Solver_def* a_solver_def)\n";

	shortwave = a_sw_def;
};

Context_domain_ccrs_def::Context_domain_ccrs_def(APL* theAPL)
						: Context_domain_ccr_def(theAPL)
{
	DEBUG << "Context_domain_ccrs_def::Context_domains_ccr_def(APL* theAPL)\n";
};

Context_domain_ccrs_def::~Context_domain_ccrs_def()
{
	DEBUG << "Context_domain_ccrs_def::~Context_domains_ccr_def()\n";
};


Shortwave_def*	Context_domain_ccrs_def::shortwave_def()
{
	DEBUG1	<< "Context_domain_ccrs_def::shortwave_def()\n";

	return shortwave;
};
