#include	"theory/Context_domain_ccrs.h"

#include	"infrastructure/Metaclass.h"
#include	"theory/Context_domain_ccrs_def.h"
#include	"theory/Convection.h"
#include	"theory/Convection_def.h"
#include	"theory/Radiation.h"
#include	"theory/Radiation_def.h"
#include	"theory/Shortwave.h"
#include	"theory/Shortwave_def.h"


Context_domain_ccrs::Context_domain_ccrs(Metaclass* meta, Context_domain_ccrs_def* def)
			: Context_domain_ccr(meta, (Context_domain_ccr_def*) def)
{
	DEBUG	<< "Context_domain_ccrs::Context_domain_ccrs(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

					// make Shortwave or derived
	if (def->shortwave_def()) {
		the_shortwave = meta->make_a("Shortwave", def->shortwave_def());
		cout << "using Shortwave theory << " << shortwave()->name()
		     << " >>\n";
	};
};

Context_domain_ccrs::Context_domain_ccrs(Conduction* cnd, Convection* cvt, Radiation* rad, Shortwave* sw, Solver* slv)
				: Context_domain_ccr(cnd, cvt, rad, slv)
{
	DEBUG	<< "Context_domain_ccrs::Context_domain_ccrs(Conduction* cnd, Convection_def* cvt,\n"
	DEBUG	<< "			Radiation* rad, Shortwave* sw, Solver* slv)\n";

	the_shortwave = sw;
};

Context_domain_ccrs::Context_domain_ccrs(APL* theAPL)  : Context_domain_ccr(theAPL)
{
	DEBUG << "Context_domain_ccrs::Context_domain_ccrs(APL* theAPL)\n";
};

Context_domain_ccrs::~Context_domain_ccrs()
{
	DEBUG << "Context_domain_ccrs::~Context_domain_ccrs()\n";
};

Shortwave*	Context_domain_ccrs::shortwave()
{
				// cast guaranteed by Metaclasses
	return (Shortwave*)the_shortwave;
};
