#include	"theory/Context_domain_ccr_def.h"

#include	"infrastructure/Metaclass.h"
#include	"theory/Convection_def.h"	// for debug oid()
#include	"theory/Radiation_def.h"	// for debug oid()


Context_domain_ccr_def::Context_domain_ccr_def(Metaclass* meta)
						: Context_domain_c_def(meta)
{
	DEBUG	<< "Context_domain_ccr_def::Context_domain_ccr_def(" << meta->oid() << ")\n";

	convection = (Convection_def*)meta->make_def_for("Convection");
	radiation = (Radiation_def*)meta->make_def_for("Radiation");
};

Context_domain_ccr_def::Context_domain_ccr_def(Conduction_def* a_conduct_def,
				       Convection_def* a_convect_def,
				       Radiation_def* a_rad_def,
				       Solver_def* a_solver_def)
			: Context_domain_c_def(a_conduct_def, a_solver_def)
{
	DEBUG	<< "Context_domain_ccr_def::Context_domain_ccr_def(Conduction_def* a_conduct_def . . . , Solver_defContext_domain_def* def)\n";

	convection = a_convect_def;
	radiation = a_rad_def;
};

Context_domain_ccr_def::~Context_domain_ccr_def()
{
	DEBUG << "Context_domain_ccr_def::~Context_domain_ccr_def()\n";
};

Context_domain_ccr_def::Context_domain_ccr_def(APL* theAPL)
					: Context_domain_c_def(theAPL)
{
	DEBUG << "Context_domain_ccr_def::Context_domain_ccr_def(APL* theAPL)\n";
};


Convection_def*	Context_domain_ccr_def::convection_def()
{
	DEBUG1	<< "Context_domain_ccr_def::convection_def()\n";

	return convection;
};

Radiation_def*	Context_domain_ccr_def::radiation_def()
{
	DEBUG1	<< "Context_domain_ccr_def::radiation_def()\n";

	return radiation;
};
