#include	"theory/Context_domain_ccr.h"

#include	"infrastructure/Metaclass.h"
#include	"theory/Context_domain_ccr_def.h"
#include	"theory/Convection.h"
#include	"theory/Convection_def.h"
#include	"theory/Radiation.h"
#include	"theory/Radiation_def.h"


Context_domain_ccr::Context_domain_ccr(Metaclass* meta, Context_domain_ccr_def* def)
			: Context_domain_c(meta, (Context_domain_c_def*) def)
{
	DEBUG	<< "Context_domain_ccr::Context_domain_ccr(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

					// make Convection or derived
	if (def->convection_def()) {
		the_convection = meta->make_a("Convection", def->convection_def());
		cout << "using Convection theory << " << convection()->name()
		     << " >>\n";
	};
					// make Conduction or derived
	if (def->radiation_def()) {
		the_radiation = meta->make_a("Radiation", def->radiation_def());
		cout << "using Radiation theory << " << radiation()->name()
		     << " >>\n";
	};
};

Context_domain_ccr::Context_domain_ccr(Conduction* cnd, Convection* cvt, Radiation* rad, Solver* slv)
						: Context_domain_c(cnd, slv)
{
	DEBUG	<< "Context_domain_ccr::Context_domain_ccr(Conduction* cnd, Convection_def* cvt,\n"
	DEBUG	<< "			Radiation* rad, Solver* slv)\n";

	the_convection = cvt;
	the_radiation = rad;
};

Context_domain_ccr::Context_domain_ccr(APL* theAPL)  : Context_domain_c(theAPL)
{
	DEBUG << "Context_domain_ccr::Context_domain_ccr(APL* theAPL)\n";
};

Context_domain_ccr::~Context_domain_ccr()
{
	DEBUG << "Context_domain_ccr::~Context_domain_ccr()\n";
};

Convection*	Context_domain_ccr::convection()
{
				// cast guaranteed by Metaclasses
	return (Convection*)the_convection;
};

Radiation*	Context_domain_ccr::radiation()
{
				// cast guaranteed by Metaclasses
	return (Radiation*)the_radiation;
};
