#include	"theory/Context_domain_c_def.h"

#include	"infrastructure/Metaclass.h"
#include	"theory/Conduction_def.h"
#include	"solver/Solver_def.h"


Context_domain_c_def::Context_domain_c_def(Metaclass* meta)
{
	DEBUG	<< "Context_domain_c_def::Context_domain_c_def(" << meta->oid() << ")\n";

	conduction = (Conduction_def*)meta->make_def_for("Conduction");
	solver = (Solver_def*)meta->make_def_for("Solver");
};

Context_domain_c_def::Context_domain_c_def(Conduction_def* a_conduct_def,
				       Solver_def* a_solver_def)
{
	DEBUG	<< "Context_domain_c_def::Context_domain_c_def(Conduction_def* a_conduct_def, Solver_def* a_solver_def)\n";

	conduction = a_conduct_def;
	solver = a_solver_def;
};

Context_domain_c_def::Context_domain_c_def(APL* theAPL)
{
	DEBUG << "Context_domain_c_def::Context_domain_c_def(APL* theAPL)\n";
};

Context_domain_c_def::~Context_domain_c_def()
{
	DEBUG << "Context_domain_c_def::~Context_domain_c_def()\n";
};


Conduction_def*	Context_domain_c_def::conduction_def()
{
	DEBUG1	<< "Context_domain_c_def::conduction_def()\n";

	return conduction;
};

Solver_def*	Context_domain_c_def::solver_def()
{
	DEBUG1	<< "Context_domain_c_def::solver_def()\n";

	return solver;
};
