#include	"theory/Context_domain_c.h"

#include	"infrastructure/Metaclass.h"
#include	"theory/Context_domain_c_def.h"
#include	"theory/Conduction.h"
#include	"theory/Conduction_def.h"
#include	"solver/Solver.h"
#include	"solver/Solver_def.h"


Context_domain_c::Context_domain_c(Metaclass* meta, Context_domain_c_def* def)
{
	DEBUG	<< "Context_domain_c::Context_domain_c(" << meta->oid() << ", ";
	DEBUG	<< a_conduction_def->oid() << ")\n";

					// make Conduction or derived
	if (def->conduction_def()) {
		the_conduction = meta->make_a("Conduction", def->conduction_def());
		cout << "using Conduction theory << " << conduction()->name()
		     << " >>\n";
	};
					// make Solver or derived
	the_solver = meta->make_a("Solver", def->solver_def());
};

Context_domain_c::Context_domain_c(Conduction* cnd, Solver* slv)
{
	DEBUG	<< "Context_domain_c::Context_domain_c(Conduction* cnd, Solver* slv)\n";

	the_conduction = cnd;
	the_solver = slv;
};

Context_domain_c::Context_domain_c(APL* theAPL)
{
	DEBUG << "Context_domain_c::Context_domain_c(APL* theAPL)\n";
};

Context_domain_c::~Context_domain_c()
{
	DEBUG << "Context_domain_c::~Context_domain_c()\n";
};

Conduction*	Context_domain_c::conduction()
{
					// cast guaranteed by Metaclasses
	return (Conduction*)the_conduction;
};

Solver*	Context_domain_c::solver()
{
				// cast guaranteed by Metaclasses
	return (Solver*)the_solver;
};
