#ifndef CONDUCTION_H
#define CONDUCTION_H

#include	"infrastructure/EKSObject.h"
class	Conduction_def;
class	Layer_es;
class	State_variable;
class	State_vector;
class	Equation_set;
class	Equation_iterator;

extern	Type*	Conduction_Type_pointer;

/*
** Base class for the calculation of conduction.
*/


class Conduction : public EKSObject {
protected:
	Conduction(Metaclass* meta, Conduction_def* def);
	Conduction(Conduction& c);
	Conduction(APL* theAPL);
	~Conduction();
public:
	Type*	getDirectType();

virtual Equation_set	generate_equations(State_vector* state_vector,
					   EKSObject*  layer,
					   Equation_iterator  layer_eqn_iter) = 0;
virtual	Equation_set	combine_equations(Equation_iterator  layer1_eqn_iter,
					  State_variable*  layer1_surface_node,
					  Equation_iterator  layer2_eqn_iter,
					  State_variable*  layer2_surface_node,
					  EKSObject*  data_supplier) = 0;
//virtual	void	add_coupling(Equation_iterator  layer1_eqn_iter,
//				     State_variable*  node_in_layer1,
//				     Equation_iterator  region2_eqn_iter,
//				     State_variable*  node_in_region2,
//				     EKSObject*  data_supplier) = 0;
virtual	void		inject_energy(Equation_iterator  layer_eqn_iter,
				      State_variable*  node_in_layer,
				      Energy  gain) = 0;
};


inline
Type*	Conduction::getDirectType()
{
	return TYPE_OF(Conduction);
};
#endif
