#ifndef SOLVER_H
#define SOLVER_H

#include	"infrastructure/EKSObject.h"
class	Solver_def;
class	Equation_iterator;
class	Matrix;
class	Vector;

extern	Type*	Solver_Type_pointer;


class Solver : public EKSObject {
protected:
	Solver(Metaclass* meta, Solver_def* def);
	Solver(Solver& c);
	Solver(APL* theAPL);
	~Solver();

	void time_discretise(Matrix& m, Vector& q, Vector& s, int n, float dt);
public:
	Type*	getDirectType();

	Solver& operator=(Solver& s);

virtual Vector& execute(Equation_iterator eqn_iter) = 0;
};


inline
Type*	Solver::getDirectType()
{
	return TYPE_OF(Solver);
};
#endif
