#include	"solver/Solver.h"

#include	"transport/Matrix.h"
#include	"transport/Vector.h"
#include	"transport/Equation_set.h"
#include	"solver/Solver_def.h"


Solver::Solver(Metaclass* meta, Solver_def* /*def*/) : EKSObject (meta)
{
	DEBUG	<< "Solver::Solver(Metaclass* meta, Solver_def* def)\n";
	directType(TYPE_OF(Solver_def));
};

Solver::Solver(Solver& c) : EKSObject (c.metaclass)
{
	DEBUG	<< "Solver::Solver(Solver& c)\n";
	directType(TYPE_OF(Solver_def));
};

Solver::Solver(APL* theAPL) : EKSObject(theAPL)
{};

Solver::~Solver()
{
	DEBUG1 << "Solver::~Solver()\n";
};


Solver& Solver::operator=(Solver& s)
{
	DEBUG1 << "Solver::operator=(Solver&)\n";

	if (this==&s) return *this;

	(void) EKSObject::operator=((EKSObject&)s);

	return *this;
};


void	Solver::time_discretise(Matrix& m, Vector& q, Vector& s, int n, float dt)
{
/* Inputs:
** 	m - coefficient matrix;
** 	q - right vector;
** 	s - state vector;
** 	n - dimension of matrix;
**	dt - time step (second).
** Outputs:
** 	m, q - can be passed to real solver.
** Note:
**	This function directly modifies the input matrix m and vector q
**	in order to save memory requirements.
**	The original m and q are not preserved.
*/

  	register int i, j;
	Vector b(n,0);

	/*calculate (2I-A*dt) and (2I+A*dt)*T */ 
  	for(i=0; i<n; i++) {
		for(j=0; j<n; j++) {
			float tmp = 0;
			tmp = m[i][j]*dt;
			m[i][j] = - tmp;
			if(i==j) {
				tmp += 2;
				m[i][j] += 2;
			}
			b[i] += tmp*s[j];	/*(2I+A*dt)*T[n]*/
		}
	}

	/*calculate (2I+A*dt)*T+2*dt*(BU) */
  	for(i=0; i<n; i++) {
		float tmp=0;
    		tmp = q[i]*2*dt;	/*2*dt*BU*/
    		b[i] += tmp;		/*(2I+A*dt)*T[n]+2*dt*BU*/
		q[i] = b[i];
	}

};
