#ifndef SKY_TEMPERATURE_H
#define SKY_TEMPERATURE_H

#include	"infrastructure/EKSObject.h"
#include	"infrastructure/Metaclass.h"
#include	"site/Sky_temperature_def.h"
class	Temperature;
class	Sun_position;
class	Time_of_day;
class	ClimateRecord;

extern	Type*	Sky_temperature_Type_pointer;

/*
** Base class for the calculation of sky temperature.
*/


class Sky_temperature : public EKSObject {
protected:
	Sky_temperature(Metaclass* meta, Sky_temperature_def* def);
	Sky_temperature(Sky_temperature& s);
	Sky_temperature(APL* theAPL);
	~Sky_temperature();

	Sky_temperature& operator=(Sky_temperature& s);
public:
	Type*	getDirectType();

	virtual	Temperature execute(ClimateRecord& a_clm_rec,
				    Sun_position& a_sun_pos,
				    Time_of_day& a_time_of_day) = 0;
};


inline
Type*	Sky_temperature::getDirectType()
{
	return TYPE_OF(Sky_temperature);
};
#endif
