#ifndef SKY_IRRADIANCE_H
#define SKY_IRRADIANCE_H

#include	"infrastructure/EKSObject.h"
#include	"infrastructure/Metaclass.h"
#include	"site/Sky_irradiance_def.h"
class	Irradiance;
class	Sun_position;
class	Orientation;
class	Time_of_day;

extern	Type*	Sky_irradiance_Type_pointer;

/*
** Base class for the calculation of sky irradiance.
*/


class Sky_irradiance : public EKSObject {
protected:
	Sky_irradiance(Metaclass* meta, Sky_irradiance_def* def);
	Sky_irradiance(Sky_irradiance& s);
	Sky_irradiance(APL* theAPL);
	~Sky_irradiance();

	Sky_irradiance& operator=(Sky_irradiance& s);
public:
	Type*	getDirectType();

	virtual	Irradiance execute(Irradiance& augmented_irradiance,
				   Sun_position& a_sun_pos_ptr,
				   Orientation& a_surface_orientation,
				   Time_of_day& a_time_of_day) = 0;
};


inline
Type*	Sky_irradiance::getDirectType()
{
	return TYPE_OF(Sky_irradiance);
};

#endif
