#ifndef SITE_H
#define SITE_H

#include	"infrastructure/EKSObject.h"
#include	"transport/Location.h"
#include 	"infrastructure/Metaclass.h"
#include	"site/Site_def.h"
class	ClimateRegime;
class	Time_of_day;

extern	Type*	Site_Type_pointer;


class Site : public EKSObject {
protected:
	char*		the_site_name;
	Location	the_site_location;

	Site(Metaclass* meta, Site_def* def);
	Site(Site& s);
	Site(APL* theAPL);
	~Site();
public:
	void	Destroy(Boolean aborted);
	Type*	getDirectType();
	
	Site& operator=(Site& s);

	virtual	Location	location();
	virtual	ClimateRegime	climateRegime(Time_of_day& a_time) = 0;
};


inline
Type*	Site::getDirectType()
{
	return TYPE_OF(Site);
};

inline
Location	Site::location()
{
	 return the_site_location;
};
#endif
