#include	"site/Site.h"

#include	<string.h>
#include	"transport/ClimateRegime.h"
#include	"transport/ClimateRecord.h"
#include	"transport/Time_of_day.h"
#include	"infrastructure/Metaclass.h"

Type*	Site_Type_pointer;


Site::Site(Metaclass* meta, Site_def* def)  : EKSObject(meta),
				  the_site_location(*def->site_location())
{
	DEBUG	<< "Site::Site(" << meta->oid() << ", ";
	DEBUG	<< def->oid() << ")\n";

	directType(TYPE_OF(Site));

	the_site_name = strdup(def->site_name());
};

Site::Site(Site& s)  : EKSObject(s.metaclass),
				  the_site_location(s.the_site_location)
{
	DEBUG << "Site::Site(" << s.oid() << ")\n";

	directType(TYPE_OF(Site));

	the_site_name = strdup(s.the_site_name);
}

Site::Site(APL* theAPL) : EKSObject(theAPL), the_site_location(theAPL)
{};

Site::~Site()
{
	DEBUG << "Site::~Site()\n";
	Destroy(FALSE);
};

void	Site::Destroy(Boolean aborted)
{
	DEBUG << "Site::Destroy(Boolean aborted)\n";

	delete (the_site_name);

	if (aborted)
		EKSObject::Destroy(aborted);
};


Site& Site::operator=(Site& s)
{
	DEBUG << "Site& Site::operator=(" << s.oid() << ")\n";

	if(this==&s) return *this;

	the_site_location = s.the_site_location;
	the_site_name = strdup(s.the_site_name);
////	(void) EKSObject::operator=((EKSObject&)s);

	return *this;
};
