#include	"EKSObject.h"
#include	"X_def.h"

#ifdef DEMO1
#include	"Context_1a.h"
#include	"Context_1a_def.h"
#include	"Site_basic.h"
#include	"Site_basic_def.h"
#include	"Climate_met.h"
#include	"Climate_met_def.h"
#include	"Context_1b.h"
#include	"Context_1b_def.h"
#include	"Context_1b_r.h"
#include	"Context_1b_r_def.h"
#include	"Context_1c.h"
#include	"Context_1c_def.h"
#include	"Site_sun.h"
#include	"Site_sun_def.h"
#include	"Sun_basic.h"
#include	"Sun_basic_def.h"
#include	"Sky_basic.h"
#include	"Sky_basic_def.h"
#include	"Perez.h"
#include	"Perez_def.h"
#include	"Berdahl_and_Martin.h"
#include	"Berdahl_and_Martin_def.h"
#include	"Context_pa.h"
#include	"Context_pa_def.h"
#include	"System.h"
#include	"System_def.h"
#include	"Component.h"
#include	"Component_def.h"
#include	"Connection.h"
#include	"Connection_def.h"
#ifdef DEMO2
#include	"Context_2a.h"
#include	"Context_2a_def.h"
#include	"Construction_basic.h"
#include	"Construction_basic_def.h"
#include	"Surface_basic.h"
#include	"Surface_basic_def.h"
#include	"Layer_basic.h"
#include	"Layer_basic_def.h"
#include	"Context_2b.h"
#include	"Context_2b_def.h"
#include	"Construction_es.h"
#include	"Construction_es_def.h"
#include	"Surface_es.h"
#include	"Surface_es_def.h"
#include	"Layer_es.h"
#include	"Layer_es_def.h"
#include	"Conduction_fd.h"
#include	"Conduction_fd_def.h"
#include	"Gauss_column_pivot.h"
#include	"Gauss_column_pivot_def.h"
#ifdef DEMO3
#include	"Context_3a.h"
#include	"Context_3a_def.h"
#include	"Building.h"
#include	"Building_def.h"
#include	"Space.h"
#include	"Space_def.h"
#include	"Room.h"
#include	"Room_def.h"
#include	"AirVolume.h"
#include	"AirVolume_def.h"
#include	"HeatSource.h"
#include	"HeatSource_def.h"
#include	"Context_3b.h"
#include	"Context_3b_def.h"
#include	"Building_es.h"
#include	"Building_es_def.h"
#include	"Room_es.h"
#include	"Room_es_def.h"
#include	"AirVolume_es.h"
#include	"AirVolume_es_def.h"
#include	"Convection_fd_1.h"
#include	"Convection_fd_1_def.h"
#include	"Radiation_fd_1.h"
#include	"Radiation_fd_1_def.h"
#endif	DEMO3
#endif	DEMO2
#endif	DEMO1


EKSObject*   instantiate(char* classname, Metaclass* meta, X_def* def = NULLPTR(X_def))
{
	DEBUG1	<<"::instantiate(" << classname <<", " << tp->oid() <<")\n";

#ifdef	DEMO1
	if (!strcmp(classname, "Context_1a"))
		return (EKSObject*) new Context_1a(meta, (Context_1a_def*)def);
	else if (!strcmp(classname, "Context_1a_def"))
		return (X_def*) new Context_1a_def(meta);
	else if (!strcmp(classname, "Site_basic"))
		return (EKSObject*) new Site_basic(meta, (Site_basic_def*)def);
	else if (!strcmp(classname, "Site_basic_def"))
		return (EKSObject*) new Site_basic_def(meta);
	else if (!strcmp(classname, "Climate_met"))
		return (EKSObject*) new Climate_met(meta, (Climate_met_def*)def);
	else if (!strcmp(classname, "Climate_met_def"))
		return (X_def*) new Climate_met_def(meta);
	else if (!strcmp(classname, "Context_1b"))
		return (EKSObject*) new Context_1b(meta, (Context_1b_def*)def);
	else if (!strcmp(classname, "Context_1b_def"))
		return (X_def*) new Context_1b_def(meta);
	else if (!strcmp(classname, "Context_1b_r"))
		return (EKSObject*) new Context_1b_r(meta, (Context_1b_r_def*)def);
	else if (!strcmp(classname, "Context_1b_r_def"))
		return (X_def*) new Context_1b_r_def(meta);
	else if (!strcmp(classname, "Site_sun"))
		return (EKSObject*) new Site_sun(meta, (Site_sun_def*)def);
	else if (!strcmp(classname, "Site_sun_def"))
		return (X_def*) new Site_sun_def(meta);
	else if (!strcmp(classname, "Sun_basic"))
		return (EKSObject*) new Sun_basic(meta, (Sun_basic_def*)def);
	else if (!strcmp(classname, "Sun_basic_def"))
		return (X_def*) new Sun_basic_def(meta);
	else if (!strcmp(classname, "Sky_basic"))
		return (EKSObject*) new Sky_basic(meta, (Sky_basic_def*)def);
	else if (!strcmp(classname, "Sky_basic_def"))
		return (X_def*) new Sky_basic_def(meta);
	else if (!strcmp(classname, "Perez"))
		return (EKSObject*) new Perez(meta, (Perez_def*)def);
	else if (!strcmp(classname, "Perez_def"))
		return (X_def*) new Perez_def(meta);
	else if (!strcmp(classname, "Berdahl_and_Martin")  ||
	         !strcmp(classname, "B&M"))
		return (EKSObject*) new Berdahl_and_Martin(meta, (Berdahl_and_Martin_def*)def);
	else if (!strcmp(classname, "Berdahl_and_Martin_def")  ||
	         !strcmp(classname, "B&M_def"))
		return (X_def*) new Berdahl_and_Martin_def(meta);
	else if (!strcmp(classname, "Context_pa"))
		return (EKSObject*) new Context_pa(meta, (Context_pa_def*)def);
	else if (!strcmp(classname, "Context_pa_def"))
		return (X_def*) new Context_pa_def(meta);
	else if (!strcmp(classname, "System"))
		return (EKSObject*) new System(meta, (System_def*)def);
	else if (!strcmp(classname, "System_def"))
		return (X_def*) new System_def(meta);
	else if (!strcmp(classname, "Component"))
		return (EKSObject*) new Component(meta, (Component_def*)def);
	else if (!strcmp(classname, "Component_def"))
		return (X_def*) new Component_def(meta);
	else if (!strcmp(classname, "Connection"))
		return (EKSObject*) new Connection(meta, (Connection_def*)def);
	else if (!strcmp(classname, "Connection_def"))
		return (X_def*) new Connection_def(meta);
#ifdef	DEMO2
	else if (!strcmp(classname, "Context_2a"))
		return (EKSObject*) new Context_2a(meta, (Context_2a_def*)def);
	else if (!strcmp(classname, "Context_2a_def"))
		return (X_def*) new Context_2a_def(meta);
	else if (!strcmp(classname, "Construction_basic"))
		return (EKSObject*) new Construction_basic(meta, (Construction_basic_def*)def);
	else if (!strcmp(classname, "Construction_basic_def"))
		return (X_def*) new Construction_basic_def(meta);
	else if (!strcmp(classname, "Surface_basic"))
		return (EKSObject*) new Surface_basic(meta, (Surface_basic_def*)def);
	else if (!strcmp(classname, "Surface_basic_def"))
		return (X_def*) new Surface_basic_def(meta);
	else if (!strcmp(classname, "Layer_basic"))
		return (EKSObject*) new Layer_basic(meta, (Layer_basic_def*)def);
	else if (!strcmp(classname, "Layer_basic_def"))
		return (X_def*) new Layer_basic_def(meta);
	else if (!strcmp(classname, "Context_2b"))
		return (EKSObject*) new Context_2b(meta, (Context_2b_def*)def);
	else if (!strcmp(classname, "Context_2b_def"))
		return (X_def*) new Context_2b_def(meta);
	else if (!strcmp(classname, "Construction_es"))
		return (EKSObject*) new Construction_es(meta, (Construction_es_def*)def);
	else if (!strcmp(classname, "Construction_es_def"))
		return (X_def*) new Construction_es_def(meta);
	else if (!strcmp(classname, "Surface_es"))
		return (EKSObject*) new Surface_es(meta, (Surface_es_def*)def);
	else if (!strcmp(classname, "Surface_es_def"))
		return (X_def*) new Surface_es_def(meta);
	else if (!strcmp(classname, "Layer_es"))
		return (EKSObject*) new Layer_es(meta, (Layer_es_def*)def);
	else if (!strcmp(classname, "Layer_es_def"))
		return (X_def*) new Layer_es_def(meta);
	else if (!strcmp(classname, "Conduction_fd"))
		return (EKSObject*) new Conduction_fd(meta, (Conduction_fd_def*)def);
	else if (!strcmp(classname, "Conduction_fd_def"))
		return (X_def*) new Conduction_fd_def(meta);
	else if (!strcmp(classname, "Gauss_column_pivot"))
		return (EKSObject*) new Gauss_column_pivot(meta, (Solver_def*)def);
	else if (!strcmp(classname, "Gauss_column_pivot_def"))
		return (X_def*) new Gauss_column_pivot_def(meta);
#ifdef DEMO3
	else if (!strcmp(classname, "Context_3a"))
		return (EKSObject*) new Context_3a(meta, (Context_3a_def*)def);
	else if (!strcmp(classname, "Context_3a_def"))
		return (X_def*) new Context_3a_def(meta);
	else if (!strcmp(classname, "Building"))
		return (EKSObject*) new Building(meta, (Building_def*)def);
	else if (!strcmp(classname, "Building_def"))
		return (X_def*) new Building_def(meta);
	else if (!strcmp(classname, "Space"))
		return (EKSObject*) new Space(meta, (Space_def*)def);
	else if (!strcmp(classname, "Space_def"))
		return (X_def*) new Space_def(meta);
	else if (!strcmp(classname, "Room"))
		return (EKSObject*) new Room(meta, (Room_def*)def);
	else if (!strcmp(classname, "Room_def"))
		return (X_def*) new Room_def(meta);
	else if (!strcmp(classname, "AirVolume"))
		return (EKSObject*) new AirVolume(meta, (AirVolume_def*)def);
	else if (!strcmp(classname, "AirVolume_def"))
		return (X_def*) new AirVolume_def(meta);
	else if (!strcmp(classname, "HeatSource"))
		return (EKSObject*) new HeatSource(meta, (HeatSource_def*)def);
	else if (!strcmp(classname, "HeatSource_def"))
		return (X_def*) new HeatSource_def(meta);
	else if (!strcmp(classname, "Context_3b"))
		return (EKSObject*) new Context_3b(meta, (Context_3b_def*)def);
	else if (!strcmp(classname, "Context_3b_def"))
		return (X_def*) new Context_3b_def(meta);
	else if (!strcmp(classname, "Building_es"))
		return (EKSObject*) new Building_es(meta, (Building_es_def*)def);
	else if (!strcmp(classname, "Building_es_def"))
		return (X_def*) new Building_es_def(meta);
	else if (!strcmp(classname, "Room_es"))
		return (EKSObject*) new Room_es(meta, (Room_es_def*)def);
	else if (!strcmp(classname, "Room_es_def"))
		return (X_def*) new Room_es_def(meta);
	else if (!strcmp(classname, "AirVolume_es"))
		return (EKSObject*) new AirVolume_es(meta, (AirVolume_es_def*)def);
	else if (!strcmp(classname, "AirVolume_es_def"))
		return (X_def*) new AirVolume_es_def(meta);
	else if (!strcmp(classname, "Convection_fd_1"))
		return (EKSObject*) new Convection_fd_1(meta, (Convection_fd_1_def*)def);
	else if (!strcmp(classname, "Convection_fd_1_def"))
		return (X_def*) new Convection_fd_1_def(meta);
	else if (!strcmp(classname, "Radiation_fd_1"))
		return (EKSObject*) new Radiation_fd_1(meta, (Radiation_fd_1_def*)def);
	else if (!strcmp(classname, "Radiation_fd_1_def"))
		return (X_def*) new Radiation_fd_1_def(meta);
#endif	DEMO3
#endif	DEMO2
#endif	DEMO1

	cerr << "make_a: don't know how to make a "<< classname <<"\n";
	return NULLPTR(EKSObject);
};
